% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibComplexQC.R
\name{LibComplexQC}
\alias{LibComplexQC}
\alias{atacLibComplexQC,ATACProc-method}
\alias{atacLibComplexQC}
\alias{libComplexQC}
\title{Quality control for library complexity}
\usage{
atacLibComplexQC(
  atacProc,
  reportOutput = NULL,
  samInput = NULL,
  singleEnd = FALSE,
  subsampleSize = Inf,
  ...
)

\S4method{atacLibComplexQC}{ATACProc}(
  atacProc,
  reportOutput = NULL,
  samInput = NULL,
  singleEnd = FALSE,
  subsampleSize = Inf,
  ...
)

libComplexQC(
  samInput,
  reportOutput = NULL,
  singleEnd = FALSE,
  subsampleSize = Inf,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacBowtie2Mapping}}
\code{\link{bowtie2Mapping}}}

\item{reportOutput}{\code{Character} scalar.
The report file path}

\item{samInput}{\code{Character} scalar.
The SAM file input path.}

\item{singleEnd}{\code{Character} scalar.
Single end data if TRUE. Paired end data if FALSE.}

\item{subsampleSize}{\code{Integer} scalar.
Down sample reads if the number is less than total number
when \code{subsample} is TRUE}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{libComplexQC}} object scalar for downstream analysis.
}
\description{
The function calculate the nonredundant fraction of reads (NRF).
Its definition is number of distinct uniquely mapping reads (i.e. after removing duplicates) / Total number of reads.
The function also Calculate PCR Bottlenecking Coefficient 1 (PBC1) and
PCR Bottlenecking Coefficient 2 (PBC2).
PBC1=M1/M_DISTINCT and PBC2=M1/M2, where
M1: number of genomic locations where exactly one read maps uniquely,
M2: number of genomic locations where two reads map uniquely
M_DISTINCT: number of distinct genomic locations to which some read maps uniquely.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{libComplexQC} instead.
}
\examples{
library(R.utils)
td <- tempdir()
setTmpDir(td)

sambzfile <- system.file(package="esATAC", "extdata", "Example.sam.bz2")
samfile <- file.path(td,"Example.sam")
bunzip2(sambzfile,destname=samfile,overwrite=TRUE,remove=FALSE)
atacproc<-libComplexQC(samInput = samfile)

}
\seealso{
\code{\link{atacBowtie2Mapping}}
\code{\link{bowtie2Mapping}}
}
\author{
Zheng Wei
}
