% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CutSiteCountR.R
\name{CutSiteCountR}
\alias{CutSiteCountR}
\alias{atacCutSiteCount,ATACProc-method}
\alias{atacCutSiteCount}
\alias{cutsitecount}
\title{Count cut site number in given motif region and plot footprint.}
\usage{
atacCutSiteCount(
  atacProcCutSite,
  atacProcMotifScan = NULL,
  csInput = NULL,
  motif_info = NULL,
  chr = c(1:22, "X", "Y"),
  matrixOutput = NULL,
  strandLength = 100,
  FootPrint = TRUE,
  prefix = NULL,
  ...
)

\S4method{atacCutSiteCount}{ATACProc}(
  atacProcCutSite,
  atacProcMotifScan = NULL,
  csInput = NULL,
  motif_info = NULL,
  chr = c(1:22, "X", "Y"),
  matrixOutput = NULL,
  strandLength = 100,
  FootPrint = TRUE,
  prefix = NULL,
  ...
)

cutsitecount(
  csInput = NULL,
  motif_info = NULL,
  chr = c(1:22, "X", "Y"),
  matrixOutput = NULL,
  strandLength = 100,
  FootPrint = TRUE,
  prefix = NULL,
  ...
)
}
\arguments{
\item{atacProcCutSite}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacExtractCutSite}}.}

\item{atacProcMotifScan}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacMotifScan}}.}

\item{csInput}{Your cut site information file(from atacExtractCutSite
function, separated by chromatin name and all cut site are sorted) path
with prefix. e.g. "/your_cut_site_information_path/prefix".}

\item{motif_info}{A rds file from function \code{\link{atacMotifScan}}.
In the rds file, it saves 3 column information(motif, motif exact position
information file path and motif length).}

\item{chr}{Which chromatin the program will processing. It must be identical
with the filename of cut site information files or subset of .
Default:c(1:22, "X", "Y").}

\item{matrixOutput}{The output directory, where to save your cut site count
of every motif position. an empty folder would be great.
Default:tmpdir/Footprint}

\item{strandLength}{How many bp(base pair) do you want to count
up/downstream of the motif. default:100.}

\item{FootPrint}{TRUE or FALSE, plot footprint or not.}

\item{prefix}{prefix for the pdf file.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar.
}
\description{
This function is used to count cut site number in given motif
regions and plot footprint. Multi-motif is supported.
NOTE: The input parameter is a a little bit complex,
\code{atacExtractCutSite} and \code{atacMotifScan} is recommended to use which
makes the entire procedure easier.
}
\details{
The parameter is simplified because of too many input file.
parameter \code{atacProcCutSite} and \code{atacProcMotifScan} contains all
input information so function \code{\link{atacExtractCutSite}} and
\code{\link{atacMotifScan}} is recommended to use together. For instance,
if you want footprint of 3 TFs (transcription factor) of human in
chr1-22, X, Y, then you need 24 chromatin cut site files, 3 motif position
files as well as 3 integers of the motif. Function \code{atacExtractCutSite} and
\code{atacMotifScan} will do all this, you just specify which motif you want.
Therefore, \code{\link{atacExtractCutSite}} and \code{\link{atacMotifScan}} is
recommended to use together.
}
\examples{

library(R.utils)
library(BSgenome.Hsapiens.UCSC.hg19)
## processing bed file
fra_path <- system.file("extdata", "chr20.50000.bed.bz2", package="esATAC")
frag <- as.vector(bunzip2(filename = fra_path,
destname = file.path(getwd(), "chr20.50000.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
cs.data <- extractcutsite(bedInput = frag, prefix = "ATAC")

## find motif position
p1bz <- system.file("extdata", "Example_peak1.bed.bz2", package="esATAC")
peak1_path <- as.vector(bunzip2(filename = p1bz,
destname = file.path(getwd(), "Example_peak1.bed"),
ext="bz2", FUN = bzfile, overwrite=TRUE, remove = FALSE))
# motif <- readRDS(system.file("extdata", "MotifPFM.rds", package="esATAC"))
# motif.data <- motifscan(peak = peak1_path, genome = BSgenome.Hsapiens.UCSC.hg19, motifs = motif)

## plot footprint
# atacCutSiteCount(atacProcCutSite = cs.data, atacProcMotifScan = motif.data)


}
\seealso{
\code{\link{atacExtractCutSite}}
\code{\link{atacMotifScan}}
}
\author{
Wei Zhang
}
