% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizChartMgr-class.R
\docType{class}
\name{EpivizChartMgr-class}
\alias{EpivizChartMgr-class}
\alias{EpivizChartMgr}
\title{Class providing chart manager for epiviz app}
\description{
Class providing chart manager for epiviz app
}
\section{Methods}{

\describe{
\item{\code{add_chart(chart_object, send_request = TRUE)}}{Add a chart to the chart manager.
 \describe{
  \item{chart_object}{an object of class \code{\link{EpivizChart}}}
  \item{send_request}{send request to app through websocket}
}}

\item{\code{get_chart_colors(chart_object_or_id)}}{List colors used in a specific chart object.
\describe{
  \item{chart_object_or_id}{An object of class \code{\link{EpivizChart}} or a 
  string indicating the chart's id assigned by chart manager}
}}

\item{\code{get_chart_settings(chart_object_or_id)}}{List chart settings for a specific chart object.
\describe{
  \item{chart_object_or_id}{An object of class \code{\link{EpivizChart}} or a 
  string indicating the chart's id assigned by chart manager}
}}

\item{\code{is_server_closed()}}{Returns \code{TRUE} if underlying server is closed.
See \code{is_closed} method in class \code{\link{EpivizServer}}.}

\item{\code{list_chart_type_colors(chart_type)}}{List colors currently used in given chart type}

\item{\code{list_chart_type_settings(chart_type)}}{List available settings for a specific chart type.
\describe{
  \item{chart_type}{the name for a chart type in R (e.g., 'BlocksTrack', 'StackedLineTrack')}
}}

\item{\code{list_chart_types(col_width = 80)}}{List charts types registered in epivizr with their default settings and colors. 
 Returns a \code{data.frame} listing available chart types and a summary of the 
 settings that can be modified.

\describe{
  \item{col_width}{Maximum length of settings list displayed.}
}}

\item{\code{list_charts()}}{Return \code{data.frame} describing charts loaded by chart manager}

\item{\code{num_charts()}}{Return the number of charts currently loaded through manager.}

\item{\code{plot(measurement_object, settings = NULL, colors = NULL, send_request = TRUE)}}{Visualize data in an \code{\link{EpivizData}} object using its default chart type.
      The method \code{get_default_chart_type} in class \code{\link{EpivizData}} is used
      to determine which chart type is used.

      \describe{
        \item{measurement_object}{an object of class \code{\link{EpivizData}}}
        \item{settings}{list of settings to use in chart (uses default chart settings if NULL)}
        \item{colors}{character vector of HEX colors to use in chart (uses default chart colors if NULL)}
      }}

\item{\code{print_chart(chart_object_or_id, file_name = NULL, file_type = c("pdf", "png"))}}{Print specific chart to file.
\describe{
 \item{chart_object_or_id}{An object of class \code{\link{EpivizChart}} or a 
   string indicating the chart's id assigned by chart manager.}
 \item{file_name}{Name of file to print to.}
 \item{file_type}{Type of file to print. One of \code{pdf} or \code{png}.}
}}

\item{\code{print_chart_info(chart_object_or_id)}}{Print settings and colors used in a specific chart object.
\describe{
  \item{chart_object_or_id}{An object of class \code{\link{EpivizChart}} or a 
  string indicating the chart's id assigned by chart manager}
}}

\item{\code{print_chart_type_info(chart_type)}}{Print settings and color information for a given chart type
\describe{
  \item{chart_type}{the name for a chart type in R (e.g., 'BlocksTrack', 'StackedLineTrack')}
}}

\item{\code{register_chart_type(
  chart_type,
  js_chart_type = paste0("epiviz.plugins.charts.", chart_type),
  js_chart_settings = list(),
  js_chart_colors = character()
)}}{Register a chart type name to a JavaScript chart type in the epiviz app.
\describe{
  \item{chart_type}{the name to use for chart type in R (e.g., 'BlocksTrack')}
  \item{js_chart_type}{the full JavaScript class name of the corresponding chart type 
    (e.g. 'epiviz.plugins.charts.BlocksTrack'). If missing it is taken from the \code{chart_type} argument}
  \item{js_chart_settings}{custom settings that can be applied to this chart type in JS.}
  \item{js_chart_colors}{default color palette applied to this chart type in JS.}
}}

\item{\code{revisualize(chart_type, chart, ...)}}{Revisualize uses data the given chart and replots it in the given chart type. The argument \code{chart} must be non-\code{NULL}.
\describe{
\item{chart_type}{a chart type registered using the \code{register_chart_type} method}
\item{chart}{a chart that includes measurements to be used in a new chart}
}}

\item{\code{rm_all_charts()}}{Remove all charts loaded by chart manager.}

\item{\code{rm_chart(chart_object_or_id)}}{Remove chart from chart manager.
\describe{
 \item{chart_object_or_id}{An object of class \code{\link{EpivizChart}} or a 
   string indicating the chart's id assigned by chart manager}
}}

\item{\code{set_chart_settings(chart_object_or_id, settings = NULL, colors = NULL)}}{Apply custom chart settings or colors to a chart object.

\describe{
  \item{chart_object_or_id}{An object of class \code{\link{EpivizChart}} or a 
    string indicating the chart's id assigned by chart manager}
  \item{settings}{a list of settings to apply to the chart}
  \item{colors}{a list of (HEX code) colors to use in the chart}
}}

\item{\code{visualize(
  chart_type,
  measurements = NULL,
  datasource = NULL,
  settings = NULL,
  colors = NULL,
  send_request = TRUE,
  ...
)}}{Visualize data use the given chart type. One of arguments \code{measurements} or \code{datasource} must be non-\code{NULL}. If \code{measurements}
is \code{NULL}, the \code{get_measurements} method in class \code{\link{EpivizData}}
is used to decide which measurements are used in the chart

\describe{
  \item{chart_type}{a chart type registered using the \code{register_chart_type} method}
  \item{measurements}{a list of \code{\link{EpivizMeasurement}} objects
    describing measurements to include in the chart}
  \item{datasource}{an object of class \code{\link{EpivizData}}, all available
    measurements from datasource are used as appropriate}
}}
}}

