% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.plot.R
\name{network.plot}
\alias{network.plot}
\title{A function to plot a network of SNPs with potential multi-SNP effects.}
\usage{
network.plot(
  graphical.score.list,
  preprocessed.list,
  n.top.scoring.pairs = NULL,
  node.shape = "circle",
  repulse.rad = 1000,
  node.size = 25,
  graph.area = 100,
  vertex.label.cex = 0.5,
  edge.width.cex = 12,
  plot = TRUE,
  edge.color.ramp = c("lightblue", "blue"),
  node.color.ramp = c("white", "red"),
  plot.legend = TRUE,
  high.ld.threshold = 0.1,
  plot.margins = c(2, 1, 2, 1),
  legend.title.cex = 1.75,
  legend.axis.cex = 1.75,
  ...
)
}
\arguments{
\item{graphical.score.list}{The list returned by function
\code{compute.graphical.scores}, or a subset of it, if there are too many
returned SNP-pairs to plot without the figure becoming too crowded.
By default, the SNPs will be labeled with their RSIDs, listed in columns 3
and 4. Users can create custom labels by changing the values in these
two columns.}

\item{preprocessed.list}{The initial list produced by function
\code{preprocess.genetic.data}.}

\item{n.top.scoring.pairs}{An integer indicating the number of top scoring
SNP-pairs to plot. Defaults to, NULL, which plots all pairs.
For large networks, plotting a subset of the top scoring pairs can improve
the appearance of the graph.}

\item{node.shape}{The desired node shape. See
\code{names(igraph:::.igraph.shapes)} for available shapes. Defaults to
circle. If both maternal and child SNPs are to be plotted, this argument
should be a vector of length 2, whose first element is the desired child SNP
shape, and second SNP is the desired mother SNP shape.}

\item{repulse.rad}{A scalar affecting the graph shape. Decrease to reduce
overlapping nodes, increase to move nodes closer together.}

\item{node.size}{A scalar affecting the size of the graph nodes.
Increase to increase size.}

\item{graph.area}{A scalar affecting the size of the graph area.
Increase to increase graph area.}

\item{vertex.label.cex}{A scalar controlling the size of the vertex label.
Increase to increase size.}

\item{edge.width.cex}{A scalar controlling the width of the graph edges.
Increase to make edges wider.}

\item{plot}{A logical indicating whether the network should be plotted.
If set to false, this function will return an igraph object to be used for
manual plotting.}

\item{edge.color.ramp}{A character vector of colors. The coloring of the
network edges will be shown on a gradient, with the lower scoring edge
weights closer to the first color specified in \code{edge.color.ramp}, and
higher scoring weights closer to the last color specified. By default, the
low scoring edges are light blue, and high scoring edges are dark blue.}

\item{node.color.ramp}{A character vector of colors. The coloring of the
network nodes will be shown on a gradient, with the lower scoring nodes
closer to the first color specified in \code{node.color.ramp}, and higher
scoring nodes closer to the last color specified. By default, the low
scoring nodes are whiter, and high scoring edges are redder.}

\item{plot.legend}{A boolean indicating whether a legend should be plotted.
Defaults to TRUE.}

\item{high.ld.threshold}{A numeric value between 0 and 1, indicating the r^2
 threshold in complements (or unaffected siblings)
above which a pair of SNPs in the same LD block
(as specified in \code{preprocessed.list}) should be considered in high LD.
Connections between these high LD SNPs will be dashed instead of solid lines.
Defaults to 0.1. If both maternal and child SNPs are among the input variants
in \code{preprocessed.list}, dashed lines can only appear between SNPs of the
same type, i.e., between two maternal SNPs, or between two child SNPs.}

\item{plot.margins}{A vector of length 4 passed to \code{par(mar = )}.
Defaults to c(2, 1, 2, 1).}

\item{legend.title.cex}{A numeric value controlling the size of the legend
titles. Defaults to 1.75. Increase to increase font size, decrease to decrease
font size.}

\item{legend.axis.cex}{A numeric value controlling the size of the legend
axis labels. Defaults to 1.75. Increase to increase font size, decrease to
decrease font size.}

\item{...}{Additional arguments to be passed to \code{plot.igraph}.}
}
\value{
An igraph object, if \code{plot} is set to FALSE.
}
\description{
This function plots a network of SNPs with potential multi-SNP effects.
}
\examples{

data(case)
data(dad)
data(mom)
case <- as.matrix(case)
dad <- as.matrix(dad)
mom <- as.matrix(mom)
data(snp.annotations)
set.seed(1400)

# preprocess data
target.snps <- c(1:3, 30:32, 60:62, 85)
pp.list <- preprocess.genetic.data(case[, target.snps],
                                   father.genetic.data = dad[ , target.snps],
                                   mother.genetic.data = mom[ , target.snps],
                                   ld.block.vec = c(3, 3, 3, 1))
## run GA for observed data

#observed data chromosome size 2
run.gadgets(pp.list, n.chromosomes = 5, chromosome.size = 2,
       results.dir = 'tmp_2',
       cluster.type = 'interactive',
       registryargs = list(file.dir = 'tmp_reg', seed = 1500),
       generations = 2, n.islands = 2, island.cluster.size = 1,
       n.migrations = 0)
 combined.res2 <- combine.islands('tmp_2', snp.annotations[ target.snps, ],
                                   pp.list, 2)
 unlink('tmp_reg', recursive = TRUE)

 #observed data chromosome size 3
 run.gadgets(pp.list, n.chromosomes = 5, chromosome.size = 3,
       results.dir = 'tmp_3',
       cluster.type = 'interactive',
       registryargs = list(file.dir = 'tmp_reg', seed = 1500),
       generations = 2, n.islands = 2, island.cluster.size = 1,
       n.migrations = 0)
 combined.res3 <- combine.islands('tmp_3', snp.annotations[ target.snps, ],
                                   pp.list, 2)
 unlink('tmp_reg', recursive = TRUE)

## create list of results
final.results <- list(combined.res2[1:3, ], combined.res3[1:3, ])

 ## compute edge scores
 set.seed(20)
 graphical.list <- compute.graphical.scores(final.results, pp.list,
                                            pval.thresh = 0.5)

## plot
set.seed(10)
network.plot(graphical.list, pp.list)

lapply(c("tmp_2", "tmp_3"), unlink, recursive = TRUE)

}
