% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructRegulon.R
\name{getTFMotifInfo}
\alias{getTFMotifInfo}
\title{Retrieve TF binding sites or motif positions}
\usage{
getTFMotifInfo(
  genome = c("hg38", "hg19", "mm10"),
  source = c("atlas", "encode.sample", "atlas.sample", "atlas.tissue"),
  metadata = FALSE,
  mode = c("occupancy", "motif"),
  peaks = NULL,
  version = 2,
  peak_number = 1000
)
}
\arguments{
\item{genome}{character string specifying the genomic build}

\item{source}{character string specifying the ChIP-seq data source and data specificity. Source followed by dot and \code{sample}
indicates sample-specific Chip-seq data. Adding \code{.tissue} to source string result in returning tissue specific data.
Providing source name without suffix tells the function to return data merged from different tissues and samples.}

\item{metadata}{logical flag specifying whether to return data or metadata only}

\item{mode}{a string indicating whether to download a GRangelist of TF binding sites ('occupancy') or motif matches ('motif').
TF binding information is retrieved from \code{\link[scMultiome:tfBinding]{scMultiome::tfBinding()}}. The
motif information was obtained from \href{https://github.com/GreenleafLab/chromVARmotifs}{chromVARmotifs} (human_pwms_v2 and mouse_pwms_v2,
version 0.2 with filtering of cisBP motifs) and is also hosted on scMultiome.}

\item{peaks}{A GRanges object indicating the peaks to perform motif annotation on.
The peak indices should match the \code{idxATAC} column in the regulon.}

\item{version}{numeric indicating data version (for details see \link[scMultiome]{tfBinding})}

\item{peak_number}{numeric indicating threshold to be applied to the number of peaks
per transcription factor in the combined version of GenomicRanges
(from all samples and tissues).}
}
\value{
A list of TF binding sites as a \code{GrangesList} object.
}
\description{
Combined transcription factor ChIP-seq data from ChIP-Atlas and ENCODE
}
\examples{
# retrieve TF binding info
\donttest{
getTFMotifInfo('mm10', 'atlas.sample')
getTFMotifInfo('hg38','atlas.tissue')
getTFMotifInfo('hg19','atlas')
}

# retrieve motif info
peaks <- GRanges(seqnames = c('chr12','chr19','chr19','chr11','chr6'),
ranges = IRanges(start = c(124914563,50850845, 50850844, 101034172, 151616327),
end = c(124914662,50850929, 50850929, 101034277, 151616394)))
grl <- getTFMotifInfo(genome = 'hg38', mode = 'motif', peaks=peaks)

}
\references{
ChIP-Atlas 2021 update: a data-mining suite for exploring epigenomic landscapes by
fully integrating ChIP-seq, ATAC-seq and Bisulfite-seq data.
Zou Z, Ohta T, Miura F, Oki S.
\emph{Nucleic Acids Research. Oxford University Press (OUP);} 2022.
\href{http://dx.doi.org/10.1093/nar/gkac199}{doi:10.1093/nar/gkac199}

ChIP‐Atlas: a data‐mining suite powered by full integration of public ChIP‐seq data.
Oki S, Ohta T, Shioi G, Hatanaka H, Ogasawara O, Okuda Y, Kawaji H, Nakaki R, Sese J, Meno C.
\emph{EMBO}; Vol. 19, EMBO reports. 2018.
\href{http://dx.doi.org/10.15252/embr.201846255}{doi:10.15252/embr.201846255}

ENCODE: {https://www.encodeproject.org/}
}
