% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statisticalTests.R
\name{regulonEnrich}
\alias{regulonEnrich}
\title{Perform geneset enrichment of user-defined regulons}
\usage{
regulonEnrich(TF, regulon, weight = "weight", weight_cutoff = 0.5, genesets)
}
\arguments{
\item{TF}{A character vector of TF names}

\item{regulon}{A matrix of weighted regulon consisting of tf, targets, corr and weight}

\item{weight}{String indicating the column name that should be used to filter target genes for geneset enrichment. Default is 'weight'.}

\item{weight_cutoff}{A numeric scalar to indicate the cutoff to filter on the column specified by \code{weight}. Default is 0.5.}

\item{genesets}{A dataframe with the first column being the name of the geneset and the second column being the name of the genes}
}
\value{
A dataframe showing the significantly enriched pathways
}
\description{
Perform geneset enrichment of user-defined regulons
}
\examples{
#retrieve genesets
msigdb.hs = msigdb::getMsigdb(org = 'hs', id = 'SYM', version = '7.4')

#convert genesets to be compatible with enricher
msigdb.hs <- msigdb.hs[unlist(lapply(msigdb.hs, function(x) {GSEABase::bcCategory(GSEABase::collectionType(x)) \%in\% c("c6", "h")}))]
gs.list <- do.call(rbind, lapply(names(msigdb.hs), function(x) {
 data.frame(gs = x, genes = GSEABase::geneIds(msigdb.hs[x][[1]]))}))

head(gs.list)

#get regulon
library(dorothea)
data(dorothea_hs, package = 'dorothea')
regulon <- dorothea_hs
enrichment_results <- regulonEnrich(c('ESR1','AR'), regulon = regulon, weight = 'mor',
genesets = gs.list)

}
\author{
Xiaosai Yao
}
