% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_iForest.R
\name{res_iForest}
\alias{res_iForest}
\title{Creates a data frame containing the results
obtained from Isolation Forest}
\usage{
res_iForest(bump, sts, outlier_score_cutoff)
}
\arguments{
\item{bump}{a DMR obtained from \link[bumphunter]{bumphunter}
(i.e. a row from \link[bumphunter]{bumphunter} method result).}

\item{sts}{the outlier score from
\link[epimutacions]{epi_iForest} function results.}

\item{outlier_score_cutoff}{numeric specifying
the outlier score cut off}
}
\value{
The function returns a data frame
containing the following information for each DMR:
\itemize{
\item genomic ranges
\item DMR base pairs
\item number and name of CpGs in DMR
\item statistics:
\itemize{
\item Outlier score
\item Outlier significance
\item Outlier direction
}
\item Sample name
}

For more information about the output see
\link[epimutacions]{epimutations}.
}
\description{
Creates a data frame containing the
genomic regions, statistics and direction for the DMRs.
}
