% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_parameters.R
\name{epi_parameters}
\alias{epi_parameters}
\title{Settings for parameters of \code{epimutations}
and \code{epimutations_one_leave_out} functions}
\usage{
epi_parameters(
  manova = list(pvalue_cutoff = 0.05),
  mlm = list(pvalue_cutoff = 0.05),
  iForest = list(outlier_score_cutoff = 0.7, ntrees = 100),
  mahdist = list(nsamp = "deterministic"),
  quantile = list(window_sz = 1000, offset_abs = 0.15, qsup = 0.995, qinf = 0.005),
  beta = list(pvalue_cutoff = 1e-06, diff_threshold = 0.1)
)
}
\arguments{
\item{manova, mlm, iForest, mahdist, quantile, beta}{method selected
in the function \link[epimutacions]{epimutations}.}

\item{pvalue_cutoff}{the threshold p value to select
which CpG regions are outliers in \code{manova},
\code{mlm} and \code{beta} methods.}

\item{outlier_score_cutoff}{The outlier score
threshold to identify outliers CpGs in
isolation forest (\code{iForest}) method. Default is \code{0.5}.}

\item{ntrees}{number of binary trees to build for the model build by
isolation forest (\code{iForest}) method.
Default is \code{100}.}

\item{nsamp}{the number of subsets used for initial
estimates in the Minimum Covariance Determinant
which is used to compute the Robust Mahalanobis
distance (\code{mahdist}).
It can be set as:
\code{"best"}, \code{"exact"}, or \code{"deterministic"}.
For \code{nsamp = "best"} exhaustive enumeration is done,
as long as the number of trials does not exceed 100'000.
For \code{nsamp = "exact"} exhaustive enumeration
will be attempted however many samples are needed.
In this case, a warning message may be displayed
saying that the computation can take a very long time.
For \code{nsamp = "deterministic"}.
For more information see \link[robustbase]{covMcd}.
Default is \code{"deterministic"}.}

\item{window_sz}{the maximum distance between
CpGs to be considered in the same DMR.
This parameter is used in \code{quantile} (default: 1000).}

\item{qsup, qinf, offset_abs}{The upper and lower quantiles (threshold)
to consider a CpG an outlier when using \code{quantile} method,
as well as the offset to consider (defaults: 0.005, 0.995, 0.15).}

\item{diff_threshold}{Minimum methylation difference between
the CpG and the mean methylation to consider a position an outlier.}
}
\value{
the function returns a list of all
set parameters for each method used in
\link[epimutacions]{epimutations} and
\link[epimutacions]{epimutations_one_leave_out} functions.
}
\description{
Allow the user to set the values
of the parameters to compute the functions
\link[epimutacions]{epimutations}
and \link[epimutacions]{epimutations_one_leave_out}.
}
\details{
Invoking \code{epi_parameters()} with
no arguments returns return a list with the default values.
}
\examples{
   #Default set of parameters
   epi_parameters()
   #change p value for manova method
   epi_parameters(manova = list("pvalue_cutoff" = 0.01))
}
