% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addOffsets.R
\name{addOffsets}
\alias{addOffsets}
\title{Add offsets to epigraHMMDataSet}
\usage{
addOffsets(object, offsets)
}
\arguments{
\item{object}{an epigraHMMDataSet}

\item{offsets}{a matrix with model offsets}
}
\value{
An epigraHMMDataSet with an 'offsets' assay filled in.
}
\description{
This function adds model offsets to epigraHMMDataSet
}
\details{
To be added
}
\examples{

# Creating dummy object
countData <- list('counts' = matrix(rpois(4e5,10),ncol = 4),
'controls' = matrix(rpois(4e5,5),ncol = 4))
colData <- data.frame(condition = c('A','A','B','B'), replicate = c(1,2,1,2))
object <- epigraHMMDataSetFromMatrix(countData,colData)

# Adding pre-computed offsets
object <- addOffsets(object = object,
                     offsets = matrix(rnorm(4e5),ncol = 4))

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
