% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiN.R
\name{epiScreen}
\alias{epiScreen}
\title{Analyse large double knock-out screen.}
\usage{
epiScreen(data, ...)
}
\arguments{
\item{data}{data matrix containing multiple single and double knock-downs
in columns and effect reporters in the rows}

\item{...}{additional parameters, e.g. for the main epiNEM function}
}
\value{
list object with vectors of double knock-downs, single knock-downs
and two matrices with doubles in the columns and singles in the rows. The
first matrix denotes the respective logical gate for the triple and the
second matrix the log-likelihood
}
\description{
This function is used to analyse knock-out screens with multiple
double and single knock-outs combined in one data set.
}
\examples{
data <- matrix(sample(c(0,1), 100*9, replace = TRUE), 100, 9)
colnames(data) <- c("A.B", "A.C", "B.C", "A", "B", "C", "D", "E", "G")
rownames(data) <- paste("E", 1:100, sep = "_")
res <- epiScreen(data)
}
\author{
Martin Pirkl
}
