% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ExpressionSet-methods.R
\docType{methods}
\name{deSet}
\alias{deSet}
\alias{deSet,ExpressionSet-method}
\title{Create a deSet object from an ExpressionSet}
\usage{
deSet(object, full.model, null.model, individual = NULL)

\S4method{deSet}{ExpressionSet}(object, full.model, null.model,
  individual = NULL)
}
\arguments{
\item{object}{\code{S4 object}: \code{\link{ExpressionSet}}}

\item{full.model}{\code{formula}: full model containing the both the
adjustment and the biological variables for the experiment.}

\item{null.model}{\code{formula}: null model containing the adjustment
variables for the experiment.}

\item{individual}{\code{factor}: information on repeated samples in
experiment.}
}
\value{
\code{\linkS4class{deSet}} object
}
\description{
Creates a \code{\linkS4class{deSet}} object that extends the
\code{\link{ExpressionSet}} object.
}
\note{
It is essential that the null and full models have the same variables
as the ExpressionSet phenoType column names.
}
\examples{
# import data
library(splines)
data(kidney)
age <- kidney$age
sex <- kidney$sex
kidexpr <- kidney$kidexpr
cov <- data.frame(sex = sex, age = age)
pDat <- as(cov, "AnnotatedDataFrame")
exp_set <- ExpressionSet(assayData = kidexpr, phenoData = pDat)

# create models
null_model <- ~sex
full_model <- ~sex + ns(age, df = 4)

# create deSet object from data
de_obj <- deSet(exp_set, null.model = null_model,
full.model = full_model)

# optionally add individuals to experiment, in this case there are 36
# individuals that were sampled twice
indSamples <- as.factor(rep(1:36, each = 2))
de_obj <- deSet(exp_set, null.model = null_model,
full.model = full_model, ind = indSamples)
summary(de_obj)
}
\author{
John Storey, Andrew Bass
}
\seealso{
\code{\linkS4class{deSet}}, \code{\link{odp}} and
\code{\link{lrt}}
}

