% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyRNASeq-annotation.R
\name{easyRNASeq annotation methods}
\alias{easyRNASeq annotation methods}
\alias{getAnnotation}
\alias{getAnnotation,AnnotParam-method}
\title{Get genic annotation from a gff3/gtf file or using biomaRt}
\usage{
\S4method{getAnnotation}{AnnotParam}(obj, verbose = FALSE, ...)
}
\arguments{
\item{obj}{An object of class \code{AnnotParam}}

\item{verbose}{a boolean to turn on verbosity}

\item{...}{See details}
}
\value{
A \code{\linkS4class{GRanges}} containing the fetched
annotations.
}
\description{
The annotation can be retrieved in two ways
\itemize{
\item{biomaRt}{Use biomaRt and Ensembl to get organism specific annotation.}
\item{gff3/gtf}{Use a gff3 or gtf local annotation file.}
}
\itemize{
\item{When using \pkg{biomaRt}, it is
important that the \code{organism} argument to
\code{\linkS4class{AnnotParam}} is set the prefix of one of the value
available using the \pkg{biomaRt}
\code{\link[biomaRt:listDatasets]{listDatasets}} function, e.g.
"Dmelanogaster".}
\item{When reading from a gff3/gtf file, a version 3 formatted
gff or a gtf (an Ensembl defined gff2 version) is expected. The function
\pkg{genomeIntervals} \code{\link[genomeIntervals]{genomeIntervals-readGff3}} is
used to import the data.}
}
}
\details{
\dots{} are for additional arguments, passed to the \pkg{biomaRt}
\code{\link[biomaRt:getBM]{getBM}} function or to the
\code{\link[easyRNASeq:easyRNASeq-annotation-internal-methods]{readGffGtf}}
internal function that takes an optional arguments: annotation.type that
default to "exon". This is used to select the proper rows of the gff or gtf
file.
}
\examples{

  \dontrun{
	library("RnaSeqTutorial")
  getAnnotation(
    AnnotParam(
      organism="Dmelanogaster",
      datasource=system.file(
  		  "extdata",
				"Dmel-mRNA-exon-r5.52.gff3",
				package="RnaSeqTutorial"),
  		type="gff3"
  ))
}

}
\author{
Nicolas Delhomme
}
\keyword{connection}
\keyword{data}
\keyword{methods}
