% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamlet.R
\name{as.dreamletResult}
\alias{as.dreamletResult}
\title{Convert list of regression fits to \code{dreamletResult}}
\usage{
as.dreamletResult(fitList, df_details = NULL)
}
\arguments{
\item{fitList}{list of regression fit with \code{dream()}}

\item{df_details}{\code{data.frame} storing assay details}
}
\value{
object of class \code{dreamletResult}
}
\description{
Convert list of regression fits to \code{dreamletResult} for downstream analysis
}
\details{
Useful for combining multiple runs of \code{dreamletCompareClusters()} into a single \code{dreamletResult} for downstream analysis
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# first comparison
ct.pairs <- c("B cells", "CD14+ Monocytes")
fit <- dreamletCompareClusters(pb, ct.pairs, method = "fixed")

# second comparison
ct.pairs2 <- c("B cells", "CD8 T cells")
fit2 <- dreamletCompareClusters(pb, ct.pairs2, method = "fixed")

# Make a list storing each result with a meaningful name
fitList <- list()

id <- paste0("[", ct.pairs[1], "]_vs_[", ct.pairs[2], "]")
fitList[[id]] <- fit

id <- paste0("[", ct.pairs2[1], "]_vs_[", ct.pairs2[2], "]")
fitList[[id]] <- fit2

# create a dreamletResult form this list
res.compare <- as.dreamletResult(fitList)
res.compare

}
