% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_from_api.R
\name{feature_to_dataframe}
\alias{feature_to_dataframe}
\title{Create a dataframe of protein features from JSON object}
\usage{
feature_to_dataframe(features_in_lists_of_six)
}
\arguments{
\item{features_in_lists_of_six}{A list of lists returned by get_features()
The number of lists corresponds to the number of accession numbers queried
using get_features. The list of 6 contains protein names and features.}
}
\value{
A dataframe with 9 variables including type, description, begin,
end, length, accession, entryName, taxid and order for plotting.
}
\description{
This function works on the object returned by the get_features() function.
It creates a data.frame of features and includes the accession number AND
an order number. It uses the extract_feat_acc function below.
}
\examples{
data("rel_json")
rel_data <- feature_to_dataframe(rel_json)
head(rel_data)

data("five_rel_list")
prot_data <- feature_to_dataframe(five_rel_list)
head(prot_data)

}
