% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantFilter.R
\name{quantFilter}
\alias{quantFilter}
\title{quantFilter Function to filter expression data of a
SummarizedExperiment object.}
\usage{
quantFilter (se, lo.bound=.25, hi.bound=.75, MEDIAN = FALSE,
na.rm = TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{lo.bound}{The lower cutoff, expressed as a percentage.}

\item{hi.bound}{The upper cutoff, expressed as a percentage.}

\item{MEDIAN}{Boolean, Calculate RowMeans or RowMedians.}

\item{na.rm}{Boolean, NA removal.}
}
\value{
Returns a filtered SummarizedExperiment object.
}
\description{
This function filters the expression of the supplied
object; quantFilter is a filtering function used to remove
rows (genes) of various expression data.
}
\details{
This function filters the expression of the supplied
object, based on a selected percentage cutoff.
}
\examples{
data(hmel.se)
f_se <- quantFilter(se, lo.bound=0.5)
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
