% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMA.R
\name{plotMA.se}
\alias{plotMA.se}
\title{plotMA.se Function to make MA plot.}
\usage{
plotMA.se(se, samplesA, samplesB, scale = NULL,
xlab = 'A', ylab = 'M', ...)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{samplesA}{Either a character vector, identifying sample
set A by either replicate name or sample name, or a numerical
vector giving the columns of data in the object that
forms sample set A.}

\item{samplesB}{Either a character vector, identifying sample
set B by either replicate name or sample name, or a numerical
vector giving the columns of data in the object that
forms sample set B.}

\item{scale}{If given, defines the scale on which the log-ratios
will be plotted.}

\item{xlab}{Label for the X-axis. Defaults to 'A'.}

\item{ylab}{Label for the Y-axis. Defaults to 'M'.}

\item{...}{Any other parameters to be passed to the plot
function.}
}
\value{
Returns MA plot.
}
\description{
This function generates MA plot.
}
\details{
This function makes MA plot from SummExperiment object.
}
\examples{
data(hmel.se)
plotMA.se(se, samplesA = 'Male', samplesB = 'Female')
}
\references{
The 'doseR' package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
