% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\docType{data}
\name{dmrs.ex}
\alias{dmrs.ex}
\title{dmrs.ex: Example results of DMRs}
\format{
a data.frame that contains the results of the inference. The
   data.frame contains one row for each candidate region, and 
   10 columns, in the following order: 1. chr = 
   chromosome, 2. start = 
   start basepair position of the region, 3. end = end basepair position
   of the region,
   4. indexStart = the index of the region's first CpG, 
   5. indexEnd = the index of the region's last CpG,
   6. L = the number of CpGs contained in the region,
   7. area = the sum of the smoothed beta values
   8. beta = the coefficient value for the condition difference,
   9. stat = the test statistic for the condition difference,
   10. pval = the permutation p-value for the significance of the test
   statistic, and 
   11. qval = the q-value for the test statistic (adjustment
   for multiple comparisons to control false discovery rate).
}
\source{
Obtained from running the examples in \code{\link{dmrseq}}. 
A script which executes these steps 
and constructs the \code{dmrs.ex} 
 object may be found in \file{inst/scripts/get_dmrs.ex.R}
}
\usage{
data(dmrs.ex)
}
\description{
Example output from \code{dmrseq} function run on the 
example dataset \code{BS.chr21}.
}
\examples{
data(dmrs.ex)
}
\keyword{datasets}
