% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/marina.R
\docType{methods}
\name{marina}
\alias{marina}
\alias{marina,ExpressionSet-method}
\alias{marina,diggit-method}
\alias{marina,matrix-method}
\title{Inference of Master Regulators}
\usage{
marina(x, ...)

\S4method{marina}{matrix}(x, y = NULL, mu = 0, regulon, per = 1000,
  cores = 1, verbose = TRUE)

\S4method{marina}{ExpressionSet}(x, pheno = "cond", group1, group2 = NULL,
  mu = 0, regulon, per = 1000, cores = 1, verbose = TRUE)

\S4method{marina}{diggit}(x, pheno, group1, group2 = NULL, mu = 0,
  regulon = NULL, per = 1000, cores = 1, verbose = TRUE)
}
\arguments{
\item{x}{Object of class diggit, expressionSet object or numerical matrix containing the test samples}

\item{...}{Additional arguments}

\item{y}{Numerical matrix containing the control samples}

\item{mu}{Number indicating the control mean when \code{y} is ommited}

\item{regulon}{Transcriptional interactome}

\item{per}{Interger indicating the number of permutations to compute the marina null model}

\item{cores}{Integer indicating the number of cores to use (1 for Windows-based systems)}

\item{verbose}{Logical, whether progress should be reported}

\item{pheno}{Character string indicating the phenotype data to use}

\item{group1}{Vector of character strings indicating the category from phenotype \code{pheno} to use as test group}

\item{group2}{Vector of character strings indicating the category from phenotype \code{pheno} to use as control group}
}
\value{
Updated diggit object with Master Regulator results
}
\description{
This function infers the master regulators for the transition between two phenotypes
}
\examples{
cores <- 3*(Sys.info()[1] != "Windows")+1
data(gbm.expression, package="diggitdata")
data(gbm.aracne, package="diggitdata")

eset <- exprs(gbmExprs)
samples <- pData(gbmExprs)[["subtype"]]
x <- eset[, samples=="MES"]
y <- eset[, samples=="PN"]
dgo <- marina(x, y, regulon=gbmTFregulon, per=100, cores=cores)
dgo
diggitMR(dgo)[1:5]
dgo <- marina(gbmExprs, pheno="subtype", group1="MES", group2="PN", regulon=gbmTFregulon, per=100, cores=cores)
dgo
diggitMR(dgo)[1:5]
x <- diggitClass(expset=gbmExprs, regulon=gbmTFregulon)
dgo <- marina(x, pheno="subtype", group1="MES", group2="PN", per=100, cores=cores)
dgo
diggitMR(dgo)[1:5]
}

