% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fcnv.R
\docType{methods}
\name{fCNV}
\alias{fCNV}
\alias{fCNV,ExpressionSet-method}
\alias{fCNV,data.frame-method}
\alias{fCNV,diggit-method}
\alias{fCNV,matrix-method}
\title{Inference of functional CNVs}
\usage{
fCNV(x, ...)

\S4method{fCNV}{diggit}(x, expset = NULL, cnv = NULL,
  method = c("spearman", "mi", "pearson", "kendall"), cores = 1,
  verbose = TRUE)

\S4method{fCNV}{ExpressionSet}(x, cnv, method = c("spearman", "mi", "pearson",
  "kendall"), cores = 1, verbose = TRUE)

\S4method{fCNV}{matrix}(x, cnv, method = c("spearman", "mi", "pearson",
  "kendall"), cores = 1, verbose = TRUE)

\S4method{fCNV}{data.frame}(x, cnv, method = c("spearman", "mi", "pearson",
  "kendall"), cores = 1, verbose = TRUE)
}
\arguments{
\item{x}{Object of class diggit, expressionSet object or numeric matrix of expression data, with features in rows and samples in columns}

\item{...}{Additional arguments}

\item{expset}{Optional numeric matrix of expression data}

\item{cnv}{Optional numeric matrix of CNVs}

\item{method}{Character string indicating the method for computing the association between CNVs and expression}

\item{cores}{Integer indicating the number of cores to use (1 for Windows-based systems)}

\item{verbose}{Logical, whether to report analysis progress}
}
\value{
Objet of class diggit with updated fCNV slot
}
\description{
This function infers functional CNVs by computing their association with gene expression
}
\examples{
data(gbm.expression, package="diggitdata")
data(gbm.cnv, package="diggitdata")
genes <- intersect(rownames(gbmExprs), rownames(gbmCNV))[1:100]
gbmCNV <- gbmCNV[match(genes, rownames(gbmCNV)), ]
dgo <- diggitClass(expset=gbmExprs, cnv=gbmCNV)

dgo <- fCNV(dgo)
dgo
diggitFcnv(dgo)[1:5]
dgo <- fCNV(gbmExprs, gbmCNV)
print(dgo)
diggitFcnv(dgo)[1:5]
dgo <- fCNV(exprs(gbmExprs), gbmCNV)
dgo
diggitFcnv(dgo)[1:5]
dgo <- fCNV(as.data.frame(exprs(gbmExprs)), gbmCNV)
dgo
diggitFcnv(dgo)[1:5]
}

