% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/0classes.R
\docType{class}
\name{diggit-class}
\alias{diggit-class}
\alias{diggitClass}
\title{The diggit class}
\usage{
diggitClass(expset = NULL, cnv = NULL, regulon = NULL, mindy = NULL,
  fcnv = NULL, mr = NULL, viper = NULL, aqtl = NULL,
  conditional = NULL)
}
\arguments{
\item{expset}{ExpressionSet object or numeric matrix of expression data, with features in rows and samples in columns}

\item{cnv}{Numeric matrix of CNV data}

\item{regulon}{Regulon class object containing the transcriptional interactome}

\item{mindy}{Regulon class object containing the post-translational interactome}

\item{fcnv}{Vector of F-CNV p-values}

\item{mr}{Vector of master regulator Z-score (NES)}

\item{viper}{Numeric matrix of VIPER results}

\item{aqtl}{Numeric matrix of aQTL p-values}

\item{conditional}{List containing the conditional analysis results}
}
\value{
Object of class diggit
}
\description{
This class stores parameters and results of the diggit algorithm

This function generates diggit class objects
}
\details{
see \code{\link[=print.diggit]{diggit-methods} for related methods}
}
\section{Slots}{

   \describe{
     \item{\code{expset}:}{ExpressionSet object containing the gene expression data}
     \item{\code{cnv}:}{Matrrix containing the CNV data}
     \item{\code{regulon}:}{Regulon object containing the transcriptional interactome}
     \item{\code{mindy}:}{Regulon object containing the post-translational interactome}
     \item{\code{fcnv}:}{Numeric vector containing the p-values for functional CNVs}
     \item{\code{mr}:}{Numeric vector of normalized enrichment scores for the MARINa analysis}
     \item{\code{viper}:}{Numeric matrix of normalized enrichment scores for the VIPER analysis}
     \item{\code{aqtl}:}{Numeric matrix of association p-values for the aQTL analysis}
     \item{\code{conditional}:}{List containing the conditional analysis results}
}
}
\examples{
data(gbm.expression, package="diggitdata")
data(gbm.aracne, package="diggitdata")
dobj <- diggitClass(expset=gbmExprs, regulon=gbmTFregulon)
print(dobj)
}

