% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseFullCoverage.R
\name{collapseFullCoverage}
\alias{collapseFullCoverage}
\title{Collapse full coverage information for efficient quantile computations}
\usage{
collapseFullCoverage(fullCov, colsubset = NULL, save = FALSE, ...)
}
\arguments{
\item{fullCov}{A list where each element is the result from
\link[=loadCoverage]{loadCoverage} used with \code{cutoff=NULL}. Can be
generated using \link{fullCoverage}.}

\item{colsubset}{Which columns of \code{coverageInfo$coverage} to use.}

\item{save}{If \code{TRUE}, the result is saved as 'collapsedFull.Rdata'.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{verbose }{ If \code{TRUE} basic status updates will be printed along
the way. Default: \code{FALSE}.}
}}
}
\value{
A list with one element per sample. Then per sample, a list with two vector
elements: \code{values} and \code{weights}. The first one is the coverage
value and the second one is the number of bases with that value.
}
\description{
For a given data set this function collapses the full coverage information
for each sample from all the chromosomes. The resulting information per
sample is the number of bases with coverage 0, 1, etc. It is similar to
using table() on a regular vector. This information is then used by
\link{sampleDepth} for calculating the sample depth adjustments. The data
set can loaded to R using (see \link{fullCoverage}) and optionally filtered
using \link{filterData}.
}
\examples{
## Collapse the coverage information for the filtered data
collapsedFull <- collapseFullCoverage(list(genomeData),
    verbose = TRUE
)
collapsedFull
\dontrun{
## You can also collapsed the raw data
collapsedFullRaw <- collapseFullCoverage(list(genomeDataRaw), verbose = TRUE)
}

}
\seealso{
\link{fullCoverage}, \link{sampleDepth}
}
\author{
Leonardo Collado-Torres
}
