% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_genes.R
\name{common_genes}
\alias{common_genes}
\title{Return a character vector of top n most frequent genes from a
SingleCellExperiment object.}
\usage{
common_genes(sce, n = 100)
}
\arguments{
\item{sce}{a SingleCellExperiment object}

\item{n}{number of genes to be returned. Defaults to n=100.}
}
\value{
character vector of n most frequently expressed genes.
}
\description{
Returns a character vector of the top n most frequently
expressed genes from the counts of the SingleCellExperiment object.
Expression is based on having a count > 0 in a given cell.
}
\examples{
data(multiplexed_scrnaseq_sce)
multiplexed_scrnaseq_sce <- common_genes(multiplexed_scrnaseq_sce)

}
