% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaCaptureC.R
\name{getOverlapWeights}
\alias{getOverlapWeights}
\title{Get the binning factors for one set of GRanges into another}
\usage{
getOverlapWeights(bins, gr, checkDisjoint = FALSE)
}
\arguments{
\item{bins}{a set of GRanges to be used for binning data.}

\item{gr}{the GRanges of the data to be binned}

\item{checkDisjoint}{= FALSE if this is TRUE it will check to see that the ranges in each of
bins and gr are disjoint}
}
\value{
A data frame giving index pairs for the intersections, widths of the intersections
and the fraction of each gr range meeting each bin
}
\description{
This function takes two GRanges, one representing a set of bins and the other representing
data to be pro-rated over those bins and returns a data frame giving the overlaps, various widths
and the fractions for pro-rating scores
}
\examples{
overlapWeights = getOverlapWeights(weightsExampleBins,weightsExampleGr)
}
