% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignaturesFromEstParam.R
\name{getSignaturesFromEstParam}
\alias{getSignaturesFromEstParam}
\title{Get signatures from an \code{EstimatedParameters} object.}
\usage{
getSignaturesFromEstParam(Param)
}
\arguments{
\item{Param}{(Mandatory) A \code{pmsignature::EstimatedParameters} object
as those produced by the de novo signature construction method
\code{pmsignature::getPMSignature}.}
}
\value{
A list of Shiraishi signatures, one object per signature. Please
see \code{readShiraishiSignatures} or the \code{decompTumor2Sig} vignette
for more information on the format of Shiraishi signatures.
}
\description{
`getSignaturesFromEstParam()` takes an \code{EstimatedParameters} object
(signatures data) as computed by the '\code{pmsignature}' package (by
\code{pmsignature::getPMSignature}; version 0.3.0) and extracts the
signature information. The signatures can then be passed to
\code{decomposeTumorGenomes}.
}
\examples{

### load signatures for breast cancer genomes from 
### Nik-Zainal et al (PMID: 22608084) in the format produced by
### pmsignature (PMID: 26630308)
pmsigdata <- system.file("extdata",
         "Nik-Zainal_PMID_22608084-pmsignature-Param.Rdata", 
         package="decompTumor2Sig")
load(pmsigdata)

### extract the signatures from the pmsignature Param object
signatures <- getSignaturesFromEstParam(Param)

}
\references{
\url{http://rmpiro.net/decompTumor2Sig/}\cr
Krueger, Piro (2019) decompTumor2Sig: Identification of mutational
signatures active in individual tumors. BMC Bioinformatics
20(Suppl 4):152.\cr
}
\seealso{
\code{\link{decompTumor2Sig}}\cr
\code{\link{readShiraishiSignatures}}
}
\author{
Rosario M. Piro, Politecnico di Milano\cr
Sandra Krueger, Freie Universitaet Berlin\cr Maintainer: Rosario
M. Piro\cr E-Mail: <rmpiro@gmail.com> or <rosariomichael.piro@polimi.it>
}
