% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plot_pca}
\alias{plot_pca}
\title{plot_pca}
\usage{
plot_pca(
  dat = NULL,
  pcx = 1,
  pcy = 2,
  metadata = NULL,
  color = NULL,
  shape = NULL,
  size = NULL,
  textonoff = "On",
  legendSelect = "samples",
  input = NULL
)
}
\arguments{
\item{dat, }{data}

\item{pcx, }{x axis label}

\item{pcy, }{y axis label}

\item{metadata, }{additional data}

\item{color, }{color for plot}

\item{shape, }{shape for plot}

\item{size, }{size of the plot}

\item{textonoff, }{text on off}

\item{legendSelect, }{select legend}

\item{input, }{input param}
}
\value{
pca list
}
\description{
Plots the PCA results for the selected dataset.
}
\examples{
    load(system.file("extdata", "demo", "demodata.Rda",
            package="debrowser"))
    metadata<-cbind(colnames(demodata[,1:6]), 
            colnames(demodata[,1:6]),
            c(rep("Cond1",3), rep("Cond2",3)))
    colnames(metadata)<-c("samples", "color", "shape")
    
    a <- plot_pca(getNormalizedMatrix(
            demodata[rowSums(demodata[,1:6])>10,1:6]),
            metadata = metadata, color = "samples",
            size = 5, shape = "shape")

}
