% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcZscore.R
\name{dcZscore}
\alias{dcZscore}
\title{DC analysis using the z-score method}
\usage{
dcZscore(
  emat,
  condition,
  from = NULL,
  to = NULL,
  fdrthresh = 0.1,
  cor.method = c("spearman", "pearson")
)
}
\arguments{
\item{emat}{a matrix, Matrix, data.frame, ExpressionSet, SummarizedExperiment
or DGEList}

\item{condition}{a numeric, (with 1's and 2's representing a binary
condition), a factor with 2 levels or a character representing 2 conditions}

\item{from}{a character vector, with the names of nodes from which
comparisons need to be performed.}

\item{to}{a character vector, with the names of nodes to which comparisons
need to be performed.}

\item{fdrthresh}{a numeric, specifying the FDR cutoff to apply to the
inferred network.}

\item{cor.method}{a character, either 'spearman' (default) or 'pearson'
specifying the correlation computation method to use.}
}
\value{
an igraph object, containing the differential coexpression network.
}
\description{
This function packs the entire DC analysis pipeline using the z-score method.
It simplifies the implementation of the analysis and increases the
flexibility of the analysis (not just limited to all pairwise comparisons).
}
\examples{
x <- matrix(rnorm(60), 10, 30)
rownames(x) = 1:10
cond <- rep(1:2, 15)
dcZscore(x, cond)
dcZscore(x, cond, to = 1:2)

}
