% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{abundance_plt}
\alias{abundance_plt}
\alias{abundance_plt,Recipe-method}
\alias{abundance_plt,PrepRecipe-method}
\title{Abundance boxplot}
\usage{
abundance_plt(
  rec,
  taxa_ids = NULL,
  type = "boxplot",
  transform = "compositional",
  scale = 1,
  top_n = 20
)

\S4method{abundance_plt}{Recipe}(
  rec,
  taxa_ids = NULL,
  type = "boxplot",
  transform = "compositional",
  scale = 1,
  top_n = 20
)

\S4method{abundance_plt}{PrepRecipe}(
  rec,
  taxa_ids = NULL,
  type = "boxplot",
  transform = "compositional",
  scale = 1,
  top_n = 20
)
}
\arguments{
\item{rec}{A Recipe or Recipe step.}

\item{taxa_ids}{Character vector with taxa_ids to plot. If taxa_ids is NULL
the significant characteristics present in all of the executed methods will
be plotted.}

\item{type}{Character vector indicating the type of the result. Options:
c("boxoplot", "heatmap").}

\item{transform}{Transformation to apply. The options include:
'compositional' (ie relative abundance), 'Z', 'log10', 'log10p',
'hellinger', 'identity', 'clr', 'alr', or any method from the
vegan::decostand function. If the value is NULL, no normalization is
applied and works with the raw counts.}

\item{scale}{Scaling constant for the abundance values when transform =
"scale".}

\item{top_n}{Maximum number of taxa to represent. Default: 20.}
}
\value{
ggplot2
}
\description{
Abundance boxplot
}
\examples{
data(test_prep_rec)

## Running the function returns a boxplot,
abundance_plt(test_prep_rec)

## Giving the value "heatmap" to the type parameter, the resulting graph
## a heatmap.
# abundance_plt(test_prep_rec, type = "heatmap")

## By default, those taxa significant in all methods are plotted. If you want
## to graph some determined features, you can pass them as vector through the
## taxa_ids parameter.
# taxa_ids <- c("Otu_96", "Otu_78", "Otu_88", "Otu_35", "Otu_94", "Otu_34")
# abundance_plt(test_prep_rec, taxa_ids = taxa_ids)
# abundance_plt(test_prep_rec, taxa_ids = taxa_ids, type = "heatmap")

## abundance_plt function needs a PrepRecipe. If you pass a a non-prep
## Recipe the output is an error.
data(test_rec)
err <- testthat::expect_error(abundance_plt(test_rec))
err
}
