% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accTest.R
\name{accTest}
\alias{accTest}
\title{tests the accuracy of several automated gating functions on monoculture
flow cytometry experiments.}
\usage{
accTest(
  fs,
  sfts = c("phytoFilter", "flowClust", "cytometree"),
  channels,
  nrun = 10000,
  ...
)
}
\arguments{
\item{fs}{flowSet with each flowFrame being a phytoplankton 
monoculture FCM experiment}

\item{sfts}{character vector of gating function to test.}

\item{channels}{channels to be used for gating}

\item{nrun}{number of times the resampling should be done}

\item{...}{extra options to be parsed to the gating function}
}
\value{
a named list containing the following objects; \itemize{
\item \strong{depth -} the multivariate-depth (median) of each
flowFrame in the flowset supplied 
\item \strong{accuracy -} computed accuracy based on resampling after
joining the flowFrames together.
}
}
\description{
This function gates all flowFrames in the supplied flowSet
             to attach cluster labels. Then it mixes up the flowSet into
             one giant flowFrame and re-gates this to attach another label.
             These labels are used to examine if the gating algorithms can
             reproduce the earlier clusters before the mixing.
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, 
                               emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
                      c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
                              Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
cells_nodebris <- debrisNc(flowframe = reducedFlowframe(cells_nonmargin),
                            ch_chlorophyll = "RED.B.HLin",
                            ch_p2 = "YEL.B.HLin",
                            ph = 0.05)
#phytoFilter specification
gateFunc(flowfile = reducedFlowframe(cells_nodebris),
              channels = c("RED.B.HLin", "YEL.B.HLin", 
              "RED.R.HLin", "FSC.HLin", "SSC.HLin"),
              sfts = "phytoFilter", 
              list(ph = 0.1, proportion = 0.90)
              )
}
