% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_plots.R
\name{plotForest}
\alias{plotForest}
\alias{plotForest,treedata-method}
\title{Forest plot}
\usage{
plotForest(x, ...)

\S4method{plotForest}{treedata}(x, ..., hide = FALSE)
}
\arguments{
\item{x}{result from \code{treeTest()}}

\item{...}{other arguments}

\item{hide}{hide rownames and legend}
}
\value{
ggplot2 object
}
\description{
Forest plot

Forest plot of effect size estimates at the leaves of the tree
}
\examples{
library(variancePartition)

# Load cell counts, clustering and metadata
# from Kang, et al. (2018) https://doi.org/10.1038/nbt.4042
data(IFNCellCounts)

# Apply crumblr transformation
cobj <- crumblr(df_cellCounts)

# Use dream workflow to analyze each cell separately
fit <- dream(cobj, ~ StimStatus + ind, info)
fit <- eBayes(fit)

# Perform multivariate test across the hierarchy
res <- treeTest(fit, cobj, hcl, coef = "StimStatusstim")

# Plot log fold changes from coef
plotForest(res)

}
