% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrisprNickase-class.R
\docType{class}
\name{CrisprNickase-class}
\alias{CrisprNickase-class}
\alias{CrisprNickase}
\alias{show,CrisprNickase-method}
\alias{pamLength,CrisprNickase-method}
\alias{spacerLength,CrisprNickase-method}
\alias{spacerLength<-,CrisprNickase-method}
\alias{pamSide,CrisprNickase-method}
\alias{pamSide<-,CrisprNickase-method}
\alias{spacerGap,CrisprNickase-method}
\alias{spacerGap<-,CrisprNickase-method}
\alias{hasSpacerGap,CrisprNickase-method}
\alias{targetLength,CrisprNickase-method}
\alias{pams,CrisprNickase-method}
\alias{pamIndices,CrisprNickase-method}
\alias{spacerIndices,CrisprNickase-method}
\alias{prototypeSequence,CrisprNickase-method}
\title{An S4 class to represent a CRISPR nickase.}
\usage{
CrisprNickase(
  nickaseName,
  nickingStrand = c("original", "opposite"),
  pams = NA_character_,
  weights = rep(1, length(pams)),
  metadata = list(),
  pam_side = NA_character_,
  spacer_gap = 0L,
  spacer_length = NA_integer_
)

\S4method{show}{CrisprNickase}(object)

\S4method{pamLength}{CrisprNickase}(object)

\S4method{spacerLength}{CrisprNickase}(object)

\S4method{spacerLength}{CrisprNickase}(object) <- value

\S4method{pamSide}{CrisprNickase}(object)

\S4method{pamSide}{CrisprNickase}(object) <- value

\S4method{spacerGap}{CrisprNickase}(object)

\S4method{spacerGap}{CrisprNickase}(object) <- value

\S4method{hasSpacerGap}{CrisprNickase}(object)

\S4method{targetLength}{CrisprNickase}(object)

\S4method{pams}{CrisprNickase}(object, primary = TRUE, ignore_pam = FALSE, as.character = FALSE)

\S4method{pamIndices}{CrisprNickase}(object)

\S4method{spacerIndices}{CrisprNickase}(object)

\S4method{prototypeSequence}{CrisprNickase}(object, primary = TRUE)
}
\arguments{
\item{nickaseName}{Name of the CRISPR nickase.}

\item{nickingStrand}{String specifying with strand with respect
to the motif sequence (5' to 3') is nicked.
Must be either "original" (default) or "opposite".}

\item{pams}{Character vector of PAM sequence motifs
written from 5' to 3. If the point of cleavage has
been determined, the precise site is marked with ^.
Only letters in the IUPAC code are accepted.
For nickases that cleave away from their
recognition sequence, the cleavage sites are indicated
in parentheses. See details for more information.}

\item{weights}{Optional numeric vector specifying relative weights
of the PAM sequences to specify cleavage probabilities.}

\item{metadata}{Optional list providing global metadata information.}

\item{pam_side}{String specifying the side of the PAM sequence
sequence with respect to the protospacer sequence. Must be either 
'3prime' (e.g. Cas9) or '5prime' (e.g. Cas12a)}

\item{spacer_gap}{Integer specifying the length (in nucleotides) between
the spacer sequence and the PAM sequence (e.g. 0 for Cas9 and Cas12a).}

\item{spacer_length}{Integer specifying the length of the spacer sequence}

\item{object}{\linkS4class{CrisprNickase} object.}

\item{value}{For \code{spacerLength<-} and \code{gapLength<-}, must be 
a non-negative integer. For \code{pamSide}, must be either
'5prime' or '3prime'.}

\item{primary}{Should only the PAM sequence with the heighest weight
be returned? If no cleavage weights are stored in the
\linkS4class{CrisprNickase} object, all sequences are returned.
TRUE by default.}

\item{ignore_pam}{Should all possible k-mer sequences for a given PAM length
be returned, irrespetively of the PAM sequence motifs stored in the
\linkS4class{CrisprNickase} object? FALSE by default.}

\item{as.character}{Should the PAM sequences be returned as a 
character vector? FALSE by default.}
}
\value{
A CrisprNickase object
}
\description{
An S4 class to represent a CRISPR nickase.
}
\section{Functions}{
\itemize{
\item \code{CrisprNickase()}: Create a \linkS4class{CrisprNickase} object

}}
\section{Slots}{

\describe{
\item{\code{pam_side}}{String specifying the side of the PAM sequence
with respect to the protospacer sequence. Must be either 
'3prime' (e.g. SpCas9) or '5prime' (e.g. AsCas12a)}

\item{\code{spacer_length}}{Integer specifying the
length of the spacer sequence}

\item{\code{spacer_gap}}{Integer specifying the length (in nucleotides)
between the spacer sequence and the PAM sequence
(e.g. 0 for SpCas9 and AsCas12a).}
}}

\section{Constructors}{

    Use the constructor \code{link{CrisprNickase}} to create
        a CrisprNickase object.
}

\section{Accessors}{

\describe{
    \item{\code{nickaseName}:}{To get the name of the CRISPR nickase.} 
    \item{\code{spacerLength}:}{To return the length of the
        spacer sequence.}
    \item{\code{targetLength}:}{To return the length of the
        target sequence (protospacer + pam).}
    \item{\code{pamLength}:}{To return the length of the PAM sequence.}
    \item{\code{pamSide}:}{To return the side of the PAM sequence with
        respect to the spacer sequence.}
    \item{\code{spacerGap}:}{To return the length of the gap between the
        PAM and spacer sequences.}
    \item{\code{pams}:}{To return the list of PAM sequences.}
}
}

\section{Setters}{

\describe{
    \item{\code{spacerGap<-}:}{To change the length of the gap between the
        PAM and spacer sequences.}
    \item{\code{pamSide<-}:}{To change the side of the PAM sequence
        with respect to the protospacer sequence.}
    \item{\code{spacerLength<-}:}{To change the length of the spacer
        sequence.}
}
}

\section{Utility functions for genomic arithmetics}{

\describe{
    \item{\code{pamIndices}:}{To return the relative coordinates of the
        PAM sequence within the protospacer sequence.}
    \item{\code{spacerIndices}:}{To return the relatiive coordinates of
        the spacer sequence within the protospacer sequence.}
}
}

\examples{
Cas9D10A <- CrisprNickase("Cas9D10A",
                          nickingStrand="opposite",
                          pams=c("(3)NGG", "(3)NAG", "(3)NGA"),
                          weights=c(1, 0.2593, 0.0694),
                          metadata=list(description="D10A-mutated  Streptococcus
                                        pyogenes Cas9 (SpCas9) nickase"),
                          pam_side="3prime",
                          spacer_length=20)

Cas9H840A <- CrisprNickase("Cas9H840A",
                           nickingStrand="original",
                           pams=c("(3)NGG", "(3)NAG", "(3)NGA"),
                           weights=c(1, 0.2593, 0.0694),
                           metadata=list(description="H840A-mutated  Streptococcus
                                         pyogenes Cas9 (SpCas9) nickase"),
                           pam_side="3prime",
                           spacer_length=20)

}
