% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDF.R
\name{makeDF}
\alias{makeDF}
\title{Construct data frame with pairwise statistics}
\usage{
makeDF(
  df,
  column,
  permutationPvalues,
  nPermutations,
  subsampleSize,
  kmin,
  kfrac
)
}
\arguments{
\item{df}{The input data frame. Must contain at least a column named
'dataset' and an additional column with values}

\item{column}{The name of the column(s) of \code{df} to be used as the basis
for the comparison}

\item{permutationPvalues}{Whether or not to calculate p-values of statistics
via permutation}

\item{nPermutations}{The number of permutations (only used if
permutationPvalues = TRUE)}

\item{subsampleSize}{The number of observations for which certain
(time-consuming) statistics will be calculated. The observations will be
selected randomly among the rows of \code{df}}

\item{kmin, kfrac}{For statistics that require the extraction of k nearest
neighbors of a given point, the number of neighbors will be max(kmin, kfrac
* nrow(df))}
}
\value{
A data table with statistics and p-values for pairwise comparisons of
  data sets, based on the provided \code{column}
}
\description{
Construct a data frame containing statistics and p-values for pairwise
comparison of data sets.
}
\author{
Charlotte Soneson
}
\keyword{internal}
