% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormMixClus-functions.R
\name{NormMixClus}
\alias{NormMixClus}
\title{Normal mixture model estimation and selection for a series of cluster numbers}
\usage{
NormMixClus(
  y_profiles,
  K,
  subset = NULL,
  parallel = TRUE,
  BPPARAM = bpparam(),
  seed = NULL,
  ...
)
}
\arguments{
\item{y_profiles}{(\emph{n} x \emph{q}) matrix of observed profiles for \emph{n}
observations and \emph{q} variables}

\item{K}{Number of clusters (a single value or a sequence of values).}

\item{subset}{Optional vector providing the indices of a subset of
genes that should be used for the co-expression analysis (i.e., row indices
of the data matrix \code{y}.}

\item{parallel}{If \code{FALSE}, no parallelization. If \code{TRUE}, parallel
execution using BiocParallel (see next argument \code{BPPARAM}). A note on running
in parallel using BiocParallel: it may be advantageous to remove large, unneeded objects
from the current R environment before calling the function, as it is possible that R's
internal garbage collection will copy these files while running on worker nodes.}

\item{BPPARAM}{Optional parameter object passed internally to \code{bplapply} when
\code{parallel=TRUE}. If not specified, the parameters last registered with \code{register}
will be used.}

\item{seed}{If desired, an integer defining the seed of the random number generator. If
\code{NULL}, a random seed is used.}

\item{...}{Additional optional parameters to be passed to \code{\link{NormMixClusK}}.}
}
\value{
An S4 object of class \code{coseqResults}, with conditional
probabilities of cluster membership for each gene in each model stored as a list of assay
data, and corresponding {log likelihood, ICL value, number of
clusters, and form of Gaussian model} for each model stored as metadata.
}
\description{
Perform co-expression and co-abudance analysis of high-throughput
sequencing data, with or without data transformation, using a Normal
mixture models. The output of \code{NormMixClus} is an S4 object of
class \code{RangedSummarizedExperiment}.
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
profiles <- transformRNAseq(countmat, norm="none",
                            transformation="arcsin")$tcounts

conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3
## Object of class coseqResults
run <- NormMixClus(y=profiles, K=2:3, iter=5)
run

## Run the Normal mixture model for K=2
## Object of class SummarizedExperiment0
run2 <- NormMixClusK(y=profiles, K=2, iter=5)

## Summary of results
summary(run)

## Re-estimate mixture parameters for the model with K=2 clusters
param <- NormMixParam(run, y_profiles=profiles)

}
\author{
Andrea Rau, Cathy Maugis-Rabusseau
}
