% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSeekeR.R
\docType{data}
\name{NucPosSimulator_nucleosome_positions}
\alias{NucPosSimulator_nucleosome_positions}
\title{Nucleosome positions detected by the NucPosSimulator software using
syntetic reads generated using a normal distribution.
For demonstration purpose.}
\format{
A \code{GRanges} containing one entry per detected
nucleosome. The surronding ranges associated to those nucleosomes are in
the dataset \code{NucPosSimulator_nucleosome_ranges}.
}
\usage{
data(NucPosSimulator_nucleosome_positions)
}
\description{
Nucleosome positions detected by the NucPosSimulator software using
syntetic reads generated using a normal distribution with a variance
of 20 for regions chr1:10000-15000.
}
\examples{

## Loading datasets
data(PING_nucleosome_positions)
data(PING_nucleosome_ranges)
data(NOrMAL_nucleosome_positions)
data(NOrMAL_nucleosome_ranges)
data(NucPosSimulator_nucleosome_positions)
data(NucPosSimulator_nucleosome_ranges)

## Assigning experiment name to each row of the dataset.
## Position and range datasets from the same sofware must
## have identical names.
names(PING_nucleosome_positions) <- rep("PING",
                            length(PING_nucleosome_positions))
names(PING_nucleosome_ranges) <- rep("PING",
                            length(PING_nucleosome_ranges))
names(NOrMAL_nucleosome_positions) <-rep("NOrMAL",
                            length(NOrMAL_nucleosome_positions))
names(NOrMAL_nucleosome_ranges) <- rep("NOrMAL",
                            length(NOrMAL_nucleosome_ranges))
names(NucPosSimulator_nucleosome_positions) <-rep("NucPosSimulator",
                            length(NucPosSimulator_nucleosome_positions))
names(NucPosSimulator_nucleosome_ranges) <- rep("NucPosSimulator",
                            length(NucPosSimulator_nucleosome_ranges))

## Calculating consensus regions for chromosome 1
## with a default region size of 50 bp (2 * extendingSize).
## The consensus regions are extended to include all genomic regions for
## all nucleosomes. However, if the consensus regions are larger than the
## genomic regions of the nucleosomes, the consensus regions are not
## shrinked.
## Nucleosomes from all software must be present in a region to
## be retained as a consensus region.
chrList <- Seqinfo(c("chr1"), c(249250621), NA)
findConsensusPeakRegions(
    narrowPeaks = c(PING_nucleosome_ranges,
                        NOrMAL_nucleosome_ranges,
                        NucPosSimulator_nucleosome_ranges),
    peaks = c(PING_nucleosome_positions,
                        NOrMAL_nucleosome_positions,
                        NucPosSimulator_nucleosome_positions),
    chrInfo = chrList,
    extendingSize = 25,
    expandToFitPeakRegion = TRUE,
    shrinkToFitPeakRegion = FALSE,
    minNbrExp = 3,
    nbrThreads = 1)

}
\references{
\itemize{
\item Sch&ouml;pflin R, Teif VB, M&uuml;ller O, Weinberg C, Rippe K, and
Wedemann G. 2013. Modeling nucleosome position distributions from
experimental nucleosome positioning maps. Bioinformatics 29 (19): 2380-86.
}
}
\seealso{
\itemize{
    \item{\code{\link{NucPosSimulator_nucleosome_ranges}} the associate
genomic ranges dataset.}
    \item{\code{\link{findConsensusPeakRegions}} for extracting regions
sharing nucleosomes from more than one experiment.}
}
}
\keyword{datasets}
