% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSyntheticData.R
\name{summarizeSyntheticDataSet}
\alias{summarizeSyntheticDataSet}
\title{Summarize a synthetic data set by some diagnostic plots}
\usage{
summarizeSyntheticDataSet(data.set, output.filename)
}
\arguments{
\item{data.set}{A data set, either a \code{\link{compData}} object or a path to an \code{.rds} file where such an object is stored.}

\item{output.filename}{The filename of the resulting html report (including the path).}
}
\description{
Summarize a synthetic data set (generated by \code{\link{generateSyntheticData}}) by some diagnostic plots.
}
\examples{
tmpdir <- normalizePath(tempdir(), winslash = "/")
mydata.obj <- generateSyntheticData(dataset = "mydata", n.vars = 1000,
                                    samples.per.cond = 5, n.diffexp = 100,
                                    output.file = file.path(tmpdir, "mydata.rds"))
if (interactive()) {
  summarizeSyntheticDataSet(data.set = file.path(tmpdir, "mydata.rds"),
                            output.filename = file.path(tmpdir, "mydata_check.html"))
}
}
\author{
Charlotte Soneson
}
