% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePhyloPoissonLogNormal.R
\name{nEffRatio}
\alias{nEffRatio}
\title{Effective Sample Size Ratio}
\usage{
nEffRatio(tree, id.condition, model, selection.strength)
}
\arguments{
\item{tree}{A phylogenetic tree. If \code{NULL}, samples are assumed to be iid.}

\item{id.condition}{A named vector giving the state of each tip (sample).}

\item{model}{The trait evolution model. One of "BM" or "OU".}

\item{selection.strength}{If \code{model="OU"}, the selection strength parameter.}
}
\value{
The ratio of sample sizes.
}
\description{
Ratio between the tree sample size and the sample size of the equivalent problem
with independent measures. A result larger than one indicates a problem that is
made "easier" by the tree structure. Note that it strongly depends on the 
tip conditions (see examples).
}
\examples{
set.seed(1289)
## Ballanced tree
ntips <- 2^5
tree <- ape::compute.brlen(ape::stree(ntips, "balanced"))
## Alt cond : nEff greater than 1
id_cond <- rep(rep(0:1, each = 2), ntips / 4)
names(id_cond) <- tree$tip.label
plot(tree); ape::tiplabels(pch = 21, col = id_cond, bg = id_cond)
compcodeR:::nEffRatio(tree, id_cond, "BM", 0)
## Bloc cond : nEff smaller than 1
id_cond <- rep(0:1, each = ntips / 2)
names(id_cond) <- tree$tip.label
plot(tree); ape::tiplabels(pch = 21, col = id_cond, bg = id_cond)
compcodeR:::nEffRatio(tree, id_cond, "BM", 0)

}
\keyword{internal}
