% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.combi.R
\name{plot.combi}
\alias{plot.combi}
\title{Make multiplots of the data integration object}
\usage{
\method{plot}{combi}(
  x,
  ...,
  Dim = c(1, 2),
  samDf = NULL,
  samShape = NULL,
  samCol = NULL,
  featurePlot = "threshold",
  featNum = 15L,
  samColValues = NULL,
  manExpFactorTaxa = 0.975,
  featSize = switch(featurePlot, threshold = 2.5, points = samSize * 0.7, density = 0.35),
  crossSize = 4,
  manExpFactorVar = 0.975,
  varNum = nrow(x$alphas),
  varSize = 2.5,
  samSize = 1.75,
  featCols = c("darkblue", "darkgreen", "grey10", "turquoise4", "blue", "green", "grey",
    "cornflowerblue", "lightgreen", "grey75"),
  strokeSize = 0.05,
  warnMonotonicity = FALSE,
  returnCoords = FALSE,
  squarePlot = TRUE,
  featAlpha = 0.5,
  featShape = 8,
  xInd = 0,
  yInd = 0,
  checkOverlap = FALSE,
  shapeValues = (21:(21 + length(unique(samDf[[samShape]]))))
)
}
\arguments{
\item{x}{the fit}

\item{...}{additional arguments, currently ignored}

\item{Dim}{the dimensions to be plotted}

\item{samDf}{a dataframe of sample variables}

\item{samShape}{A variable name from samDf used to shape the samples}

\item{samCol}{A variable name from samDf used to colour the samples}

\item{featurePlot}{A character string, either "threshold", "points" or
"density". See details}

\item{featNum, varNum}{The number of features and variables to plot}

\item{samColValues}{Colours for the samples}

\item{manExpFactorTaxa, manExpFactorVar}{Expansion factors for taxa and
variables, normally calculated natively}

\item{featSize, crossSize, varSize, samSize, strokeSize}{Size parameters for
the features (text, dots or density contour lines), central cross, variable labels, sample dots, sample
strokes and feature contour lines}

\item{featCols}{Colours for the features}

\item{warnMonotonicity}{A boolean, should a warning be thrown when the
feature proportions of compositional views do not all vary monotonically
with all latent variables?}

\item{returnCoords}{A boolean, should coordinates be returned, e.g. for use
in thrird party software}

\item{squarePlot}{A boolean, should the axes be square? Strongly recommended}

\item{featAlpha}{Controls the transparacny of the features}

\item{featShape}{Shape of feature dots when featurePlot = "points"}

\item{xInd, yInd}{x and y indentations}

\item{checkOverlap}{A boolean, should overlapping labels be omitted?}

\item{shapeValues}{the shapes, as numeric values}
}
\value{
A ggplot object containing the plot
}
\description{
Make multiplots of the data integration object
}
\details{
It is usually impossible to plot all features with their labels.
Therefore, he default option of the 'featurePlot' parameter is "threshold",
whereby only the 'featNum" features furthest away from the origin are shown.
Alternatively, the "points" or "density" options are available to plot all
features as a point or density cloud, but without labels.
}
\examples{
data(Zhang)
\dontrun{
#Unconstrained
microMetaboInt = combi(
list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
logTransformGaussian = FALSE, verbose = TRUE)
#Constrained
microMetaboIntConstr = combi(
    list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
    distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
    logTransformGaussian = FALSE, covariates = zhangMetavars, verbose = TRUE)}
    #Load the fits
load(system.file("extdata", "zhangFits.RData", package = "combi"))
plot(microMetaboInt)
plot(microMetaboInt, samDf = zhangMetavars, samCol = "ABX")
#Plot all features as points or density
plot(microMetaboInt, samDf = zhangMetavars, samCol = "ABX",
featurePlot = "points")
plot(microMetaboInt, samDf = zhangMetavars, samCol = "ABX",
featurePlot = "density")
#Constrained
plot(microMetaboIntConstr, samDf = zhangMetavars, samCol = "ABX")
}
