% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/utils.R
\name{extract.gct}
\alias{extract.gct}
\alias{extract_gct}
\title{Exract elements from a GCT matrix}
\usage{
extract.gct(...)

extract_gct(
  g,
  row_field,
  col_field,
  rdesc = NULL,
  cdesc = NULL,
  row_keyfield = "id",
  col_keyfield = "id"
)
}
\arguments{
\item{...}{arguments passed on to \code{extract_gct}}

\item{g}{the GCT object}

\item{row_field}{the column name in rdesc to search on}

\item{col_field}{the column name in cdesc to search on}

\item{rdesc}{a \code{data.frame} of row annotations}

\item{cdesc}{a \code{data.frame} of column annotations}

\item{row_keyfield}{the column name of \code{rdesc} to use
for annotating the rows of \code{g}}

\item{col_keyfield}{the column name of \code{cdesc} to use
for annotating the rows of \code{g}}
}
\value{
a list of the following elements
\describe{
  \item{mask}{a logical matrix of the same dimensions as
        \code{ds@mat} indicating which matrix elements have
        been extracted}
 \item{idx}{an array index into \code{ds@mat}
        representing which elements have been extracted}
 \item{vals}{a vector of the extracted values}
 }
}
\description{
extract the elements from a \code{GCT} object
  where the values of \code{row_field} and \code{col_field}
  are the same. A concrete example is if \code{g} represents
  a matrix of signatures of genetic perturbations, and you wan
  to extract all the values of the targeted genes.
}
\examples{
# get the values for all targeted genes from a 
# dataset of knockdown experiments 
res <- extract_gct(kd_gct, row_field="pr_gene_symbol",
  col_field="pert_mfc_desc")
str(res)
stats::quantile(res$vals)

}
