% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_pathway_gsea}
\alias{plot_pathway_gsea}
\title{plot GSEA pathway scores as heatmap,
returns a list containing results and plot.}
\usage{
plot_pathway_gsea(
  mat,
  pathway_list,
  n_perm = 1000,
  scale = TRUE,
  topn = 5,
  returning = "both"
)
}
\arguments{
\item{mat}{expression matrix}

\item{pathway_list}{a list of vectors, each named for a specific pathway,
or dataframe}

\item{n_perm}{Number of permutation for fgsea function. Defaults to 1000.}

\item{scale}{convert expr_mat into zscores prior to running GSEA?,
default = TRUE}

\item{topn}{number of top pathways to plot}

\item{returning}{to return "both" list and plot, or either one}
}
\value{
list of matrix and plot, or just plot, matrix of GSEA NES values,
cell types as row names, pathways as column names
}
\description{
plot GSEA pathway scores as heatmap,
returns a list containing results and plot.
}
\examples{
gl <- list(
    "n" = c("PPBP", "LYZ", "S100A9"),
    "a" = c("IGLL5", "GNLY", "FTL")
)

pbmc_avg <- average_clusters(
    mat = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified"
)

plot_pathway_gsea(
    pbmc_avg,
    gl,
    5
)
}
