% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_access.R
\name{object_data}
\alias{object_data}
\alias{object_data.Seurat}
\alias{object_data.SingleCellExperiment}
\title{Function to access object data}
\usage{
object_data(object, ...)

\method{object_data}{Seurat}(object, slot, n_genes = 1000, ...)

\method{object_data}{SingleCellExperiment}(object, slot, ...)
}
\arguments{
\item{object}{object after tsne or umap projections
and clustering}

\item{...}{additional arguments}

\item{slot}{data to access}

\item{n_genes}{number of genes limit for Seurat variable genes, by default 1000,
set to 0 to use all variable genes (generally not recommended)}
}
\value{
expression matrix, with genes as row names,
and cell types as column names
}
\description{
Function to access object data
}
\examples{
so <- so_pbmc()
mat <- object_data(
    object = so,
    slot = "data"
)
mat[1:3, 1:3]
sce <- sce_pbmc()
mat <- object_data(
    object = sce,
    slot = "data"
)
mat[1:3, 1:3]
}
