% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks_per_gene.R
\name{num_peaks_per_gene}
\alias{num_peaks_per_gene}
\title{Aggregate peak assignments over the \code{gene_id} column}
\usage{
num_peaks_per_gene(assigned_peaks, locusdef, mappa = NULL)
}
\arguments{
\item{assigned_peaks}{A \code{data.frame} resulting from \code{assign_peaks()} or \code{assign_peak_segments()}.}

\item{locusdef}{A locus definition object from \code{chipenrich.data}.}

\item{mappa}{A mappability object from \code{chipenrich.data}.}
}
\value{
A \code{data.frame} with columns \code{gene_id, length, log10_length, num_peaks, peak}. The result is used directly in the gene set enrichment tests in \code{chipenrich()}.
}
\description{
For each \code{gene_id}, determine the locus length and the number of peaks.
}
\details{
Typically, this function will not be used alone, but inside \code{chipenrich()}.
}
\examples{

data('locusdef.hg19.nearest_tss', package = 'chipenrich.data')
data('tss.hg19', package = 'chipenrich.data')

file = system.file('extdata', 'test_assign.bed', package = 'chipenrich')
peaks = read_bed(file)

assigned_peaks = assign_peaks(
	peaks = peaks,
	locusdef = locusdef.hg19.nearest_tss,
	tss = tss.hg19)

ppg = num_peaks_per_gene(
	assigned_peaks = assigned_peaks,
	locusdef = locusdef.hg19.nearest_tss,
	mappa = NULL)

}
