% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_transcripts.R
\name{plot_transcripts}
\alias{plot_transcripts}
\title{Plot transcripts for each partner gene in a fusion event.}
\usage{
plot_transcripts(
  fusion,
  edb = NULL,
  bamfile = NULL,
  which_transcripts = "exonBoundary",
  non_ucsc = TRUE,
  ylim = c(0, 1000),
  reduce_transcripts = FALSE,
  bedgraphfile = NULL
)
}
\arguments{
\item{fusion}{The Fusion object to plot.}

\item{edb}{The edb object that will be used to fetch data.}

\item{bamfile}{The bamfile with RNA-seq data.}

\item{which_transcripts}{This character vector decides which transcripts are
to be plotted. Can be "exonBoundary", "withinExon", "withinIntron",
"intergenic", or a character vector with specific transcript ids. Default
value is "exonBoundary".}

\item{non_ucsc}{Boolean indicating whether or not the bamfile used has UCSC-
styled chromosome names (i.e. with the "chr" prefix). Setting this to true
lets you use a bamfile with chromosome names like "1" and "X", instead of
"chr1" and "chrX".}

\item{ylim}{Limits for the coverage y-axis.}

\item{reduce_transcripts}{Boolean indicating whether or not to reduce all
transcripts into a single transcript for each partner gene.}

\item{bedgraphfile}{A bedGraph file to use instead of the bamfile to plot
coverage.}
}
\value{
Creates a fusion transcripts plot.
}
\description{
This function takes a fusion object and an ensembldb object and plots
transcripts for both genes, showing which parts of each genes are included
in the fusion event. If the bamfile parameter is set, then the coverage is
plotted beneath the transcripts.
}
\examples{
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# bamfile with reads in the regions of this fusion event
bamfile5267 <- system.file(
  "extdata",
  "fusion5267and11759reads.bam",
  package="chimeraviz")
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 500, height = 500)
# Plot!
plot_transcripts(
  fusion = fusion,
  edb = edb,
  bamfile = bamfile5267,
  non_ucsc = TRUE)
# Close device
dev.off()

# Example using a .bedGraph file instead of a .bam file:
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# bedgraphfile with coverage data from the regions of this fusion event
bedgraphfile <- system.file(
  "extdata",
  "fusion5267and11759reads.bedGraph",
  package="chimeraviz")
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 500, height = 500)
# Plot!
plot_transcripts(
  fusion = fusion,
  edb = edb,
  bedgraphfile = bedgraphfile,
  non_ucsc = TRUE)
# Close device
dev.off()

}
