% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_transcripts_ensembl_db}
\alias{get_transcripts_ensembl_db}
\title{Retrieves transcripts for partner genes in a Fusion object using Ensembldb}
\usage{
get_transcripts_ensembl_db(fusion, edb)
}
\arguments{
\item{fusion}{The fusion object to find transcripts for.}

\item{edb}{The edb object used to fetch data from.}
}
\value{
An updated fusion object with transcript data stored.
}
\description{
This function will retrieve transcripts for both genes in a fusion. It will
check all transcripts and decide for each transcript if the fusion breakpoint
happens at 1) an exon boundary, 2) within an exon, or 3) within an intron.
This is done because fusions happening at exon boundaries are more likely to
produce biologically interesting gene products. The function returns an
updated Fusion object, where the fusion@gene_upstream@transcriptsX slots are set with
transcript information.
}
\examples{
# Load fusion data and choose a fusion object:
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Create edb object
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# Add transcripts data to fusion object
fusion <- get_transcripts_ensembl_db(fusion, edb)
# The transcripts are now accessible through fusion@gene_upstream@transcripts and
# fusion@gene_downstream@transcripts .

}
