% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{saveDelayedObject,ANY-method}
\alias{saveDelayedObject,ANY-method}
\title{Saving other seed classes}
\usage{
\S4method{saveDelayedObject}{ANY}(x, file, name)
}
\arguments{
\item{x}{An R object of a supported class, see Details.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of \code{x}.
}
\description{
Optional methods to save other classes, depending on the availability of the packages in the current R installation.
}
\details{
The ANY method will dispatch to classes that are implemented in other packages:
\itemize{
\item If \code{x} is a LowRankMatrixSeed from the \pkg{BiocSingular} package, it is handled as a delayed matrix product.
\item If \code{x} is a ResidualMatrixSeed from the \pkg{ResidualMatrix} package, it is converted into the corresponding series of delayed operations.
However, the top-level group will contain a \code{"r_type_hint"} dataset to indicate that it was originally a ResidualMatrix object.
This provides R clients with the opportunity to reload it as a ResidualMatrix, which may be more efficient than the naive DelayedArray representation.
\item Otherwise, if \code{x} comes from package \pkg{Y}, we will try to load \pkg{chihaya.Y}.
This is assumed to define an appropriate \code{saveDelayedObject} method for \code{x}.
}
}
\examples{
# Saving a matrix product.
library(BiocSingular)
left <- matrix(rnorm(100000), ncol=20)
right <- matrix(rnorm(50000), ncol=20)
thing <- LowRankMatrix(left, right)
temp <- tempfile()
saveDelayed(thing, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
