% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_transformed_sl.R
\name{plot_transformed_sl}
\alias{plot_transformed_sl}
\title{Plot z-tranformed Short/Long-fragment Ratio}
\usage{
plot_transformed_sl(
  sample_transformed_sl,
  sample_segment_df = NULL,
  ylim = c(-30, 30),
  genome = "hg19"
)
}
\arguments{
\item{sample_transformed_sl}{Dataframe z-transformed SLRatio from get_zscore_profile}

\item{sample_segment_df}{Dataframe segmenation from segmentByPSCB}

\item{ylim}{plot y-axis limit}

\item{genome}{Character; version of reference genome (default hg19)}
}
\value{
Genome-wide plot of z-transformed SLRatio
}
\description{
Plot z-tranformed Short/Long-fragment Ratio
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)
sample_zscore_segment <- segmentByPSCB(sample_zscore)
plot_transformed_sl(sample_zscore, sample_zscore_segment)
## Change reference genome
plot_transformed_sl(sample_zscore, sample_zscore_segment,genome="hg38")
}
