% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBam.R
\name{readBam}
\alias{readBam}
\title{Read bam file into a curated GRanges object}
\usage{
readBam(
  bamfile,
  chromosome_to_keep = paste0("chr", 1:22),
  strand_mode = 1,
  genome_label = "hg19",
  outdir = NA,
  ...
)
}
\arguments{
\item{bamfile}{The bam file name.}

\item{chromosome_to_keep}{Should be a character vector containing the 
seqnames to be kept in the GRanges object. 
Default is paste0("chr", 1:22).}

\item{strand_mode}{Usually the strand_mode  = 1 means the First read is 
aligned to positive strand. Details please see GenomicAlignments docs.}

\item{genome_label}{The Genome you used in the alignment. 
Should be "hg19" or "hg38" or "hg38-NCBI. Default is "hg19". 
Note: "hg19" will load BSgenome.Hsapiens.UCSC.hg19 package, which is 
Full genome sequences for Homo sapiens (Human) as provided by 
UCSC (hg19, based on GRCh37.p13) and stored in Biostrings objects; 
"hg38" will load BSgenome.Hsapiens.UCSC.hg38 package, which is 
Full genome sequences for Homo sapiens (Human) as provided by 
UCSC (hg38, based on GRCh38.p13) and stored in Biostrings objects.
"hg38-NCBI" will load BSgenome.Hsapiens.NCBI.GRCh38 package, which is 
full genome sequences for Homo sapiens (Human) as provided by 
NCBI (GRCh38, 2013-12-17) and stored in Biostrings objects.}

\item{outdir}{The path for saving rds file. Default is NA, i.e. not saving.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
This function returns curated GRanges object.
}
\description{
Read bam file into a curated GRanges object
}
\examples{
\dontrun{

object <- read_bam(bamfile = "/path/to/bamfile.bam", 
                   outdir = "./",
                   chromosome_to_keep = c("chr1", "chr2", "chr3"))
}

}
\author{
Haichao Wang
}
