% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R, R/datasets.R, R/files.R,
%   R/publisher_metadata.R
\name{collections}
\alias{collections}
\alias{datasets}
\alias{datasets_visualize}
\alias{files}
\alias{files_download}
\alias{links}
\alias{authors}
\alias{publisher_metadata}
\title{Query cellxgene collections, datasets, and files}
\usage{
collections(cellxgene_db = db())

datasets(cellxgene_db = db())

datasets_visualize(tbl)

files(cellxgene_db = db())

files_download(tbl, dry.run = TRUE, cache.path = .cellxgene_cache_path())

links(cellxgene_db = db())

authors(cellxgene_db = db())

publisher_metadata(cellxgene_db = db())
}
\arguments{
\item{cellxgene_db}{an optional 'cellxgene_db' object, as returned
by \code{db()}.}

\item{tbl}{a \code{tibble()} typically derived from \code{datasets(db)} or
\code{files(db)} and containing columns \code{dataset_id} (for
\code{datasets_visualize()}), or columns \code{dataset_id}, \code{file_id},
and \code{filetype} (for \code{files_download()}).}

\item{dry.run}{logical(1) indicating whether the (often large)
file(s) in \code{tbl} should be downloaded to a local cache. Files
are not downloaded when \code{dry.run = TRUE} (default).}

\item{cache.path}{character(1) directory in which to cache
downloaded files. The directory must already exist. The default
is \code{tools::R_user_dir("cellxgenedp", "cache")}, a
package-specific path in the user home directory.}
}
\value{
Each function returns a tibble describing the corresponding
component of the database.

\code{files_download()} returns a character() vector of paths to
the local files.

\code{links()} returns a tibble of external links associated
with each collection. Common links includ DOI, raw data / data
sources, and lab websites.

\code{authors()} returns a tibble of authors associated with
each collection.

\code{publisher_metadata()} returns a tibble of publisher
metadata (journal, publicate date, doi) associated with each
collection.
}
\description{
\code{files_download()} retrieves one or more cellxgene
files to a cache on the local system.

\code{links()}, \code{authors()} and \code{publisher_metadata()} are
helper functions to extract 'nested' information from
collections.
}
\examples{
db <- db()

collections(db)

collections(db) |>
    dplyr::glimpse()

datasets(db) |>
    dplyr::glimpse()

\donttest{
if (interactive()) {
    ## visualize the first dataset
    datasets(db) |>
        dplyr::slice(1) |>
        datasets_visualize()
}
}
files(db) |>
    dplyr::glimpse()

\dontrun{
files(db) |>
    dplyr::slice(1) |>
    files_download(dry.run = FALSE)
}

## common links to external data
links(db) |>
    dplyr::count(link_type)

## authors per collection
authors() |>
    dplyr::count(collection_id, sort = TRUE)

publisher_metadata() |>
    dplyr::glimpse()

}
