% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db}
\alias{db}
\title{Retrieve updated cellxgene database metadata}
\usage{
db(overwrite = .db_online() && .db_first())
}
\arguments{
\item{overwrite}{logical(1) indicating whether the database of
collections should be updated from the internet (the default,
when internet is available and, in an interactive session, the
user requests the update), or read from disk (assuming previous
successful access to the internet).  \code{overwrite = FALSE} might
be useful for reproducibility, testing, or when working in an
environment with restricted internet access.}
}
\value{
\code{db()} returns an object of class 'cellxgene_db',
summarizing available collections, datasets, and files.
}
\description{
Retrieve updated cellxgene database metadata
}
\details{
The database is retrieved from the cellxgene data portal
web site. 'collections' metadata are retrieved on each call;
metadata on each collection is cached locally for re-use.
}
\examples{
db()

}
