% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{VisualizeImg}
\alias{VisualizeImg}
\title{Visualize a matrix image}
\usage{
VisualizeImg(img_mtx, col = NULL, ...)
}
\arguments{
\item{img_mtx}{numeric matrix corresponding to a image}

\item{col}{character vector corresponding to a valid color palette}

\item{...}{additional arguments will be passed to graphics::image()}
}
\value{
None
}
\description{
Shows an image representation of a numeric matrix. Typically,
this is a non-negative numeric matrix, where signal (high values)
corresponds to the presence of cells, or cell-like particles.
}
\examples{
x <- vapply(
    seq_len(20),
    function(i) {runif(n = 20, min = 0, max = 10)},
    FUN.VALUE = numeric(20)
)
cellmigRation:::VisualizeImg(x)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{cellTracker}
\keyword{internal}
