% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursiveSplit.R
\name{recursiveSplitModule}
\alias{recursiveSplitModule}
\alias{recursiveSplitModule,SingleCellExperiment-method}
\alias{recursiveSplitModule,matrix-method}
\title{Recursive module splitting}
\usage{
recursiveSplitModule(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  initialL = 10,
  maxL = 100,
  tempK = 100,
  zInit = NULL,
  sampleLabel = NULL,
  alpha = 1,
  beta = 1,
  delta = 1,
  gamma = 1,
  minFeature = 3,
  reorder = TRUE,
  seed = 12345,
  perplexity = TRUE,
  doResampling = FALSE,
  numResample = 5,
  verbose = TRUE,
  logfile = NULL
)

\S4method{recursiveSplitModule}{SingleCellExperiment}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  initialL = 10,
  maxL = 100,
  tempK = 100,
  zInit = NULL,
  sampleLabel = NULL,
  alpha = 1,
  beta = 1,
  delta = 1,
  gamma = 1,
  minFeature = 3,
  reorder = TRUE,
  seed = 12345,
  perplexity = TRUE,
  doResampling = FALSE,
  numResample = 5,
  verbose = TRUE,
  logfile = NULL
)

\S4method{recursiveSplitModule}{matrix}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  initialL = 10,
  maxL = 100,
  tempK = 100,
  zInit = NULL,
  sampleLabel = NULL,
  alpha = 1,
  beta = 1,
  delta = 1,
  gamma = 1,
  minFeature = 3,
  reorder = TRUE,
  seed = 12345,
  perplexity = TRUE,
  doResampling = FALSE,
  numResample = 5,
  verbose = TRUE,
  logfile = NULL
)
}
\arguments{
\item{x}{A numeric \link{matrix} of counts or a
\linkS4class{SingleCellExperiment}
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a
\link[SingleCellExperiment]{SingleCellExperiment} object. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{initialL}{Integer. Initial number of modules.}

\item{maxL}{Integer. Maximum number of modules.}

\item{tempK}{Integer. Number of temporary cell populations to identify and
use in module splitting. Only used if \code{zInit = NULL} Collapsing cells
to a relatively smaller number of cell popluations will increase the
speed of module clustering and tend to produce better modules. This number
should be larger than the number of true cell populations expected in the
dataset. Default \code{100}.}

\item{zInit}{Integer vector. Collapse cells to cell populations based on
labels in \code{zInit} and then perform module splitting. If NULL, no
collapsing will be performed unless \code{tempK} is specified.
Default \code{NULL}.}

\item{sampleLabel}{Vector or factor. Denotes the sample label for each cell
(column) in the count matrix. Default \code{NULL}.}

\item{alpha}{Numeric. Concentration parameter for Theta. Adds a pseudocount
to each cell population in each sample. Only used if \code{zInit} is set.
Default \code{1}.}

\item{beta}{Numeric. Concentration parameter for Phi. Adds a pseudocount
to each feature module in each cell. Default 1.}

\item{delta}{Numeric. Concentration parameter for Psi. Adds a pseudocount
to each feature in each module. Default 1.}

\item{gamma}{Numeric. Concentration parameter for Eta. Adds a pseudocount
to the number of features in each module. Default 1.}

\item{minFeature}{Integer. Only attempt to split modules with at least this
many features.}

\item{reorder}{Logical. Whether to reorder modules using hierarchical
clustering after each model has been created. If FALSE, module numbers will
correspond to the split which created the module (i.e. 'L15' was created at
split 15, 'L16' was created at split 16, etc.). Default TRUE.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}

\item{perplexity}{Logical. Whether to calculate perplexity for each model.
If FALSE, then perplexity can be calculated later with
\link{resamplePerplexity}. Default \code{TRUE}.}

\item{doResampling}{Boolean. If \code{TRUE}, then each cell in the counts
matrix will be resampled according to a multinomial distribution to introduce
noise before calculating perplexity. Default \code{FALSE}.}

\item{numResample}{Integer. The number of times to resample the counts matrix
for evaluating perplexity if \code{doResampling} is set to \code{TRUE}.
Default \code{5}.}

\item{verbose}{Logical. Whether to print log messages. Default TRUE.}

\item{logfile}{Character. Messages will be redirected to a file named
"logfile". If NULL, messages will be printed to stdout.  Default NULL.}
}
\value{
A \linkS4class{SingleCellExperiment} object. Function
 parameter settings and celda model results are stored in the
 \link{metadata} \code{"celda_grid_search"} slot. The models in
 the list will be of class \link{celda_G} if \code{zInit = NULL} or
 \link{celda_CG} if \code{zInit} is set.
}
\description{
Uses the \link{celda_G} model to cluster features into modules
 for a range of possible L's. The module labels of the previous "L-1" model
 are used as the initial values in the current model with L modules. The best
 split of an existing module is found to create the L-th module. This
 procedure is much faster than randomly initializing each model with a
 different L.
}
\examples{
data(sceCeldaCG)
## Create models that range from L=3 to L=20 by recursively splitting modules
## into two
moduleSplit <- recursiveSplitModule(sceCeldaCG, initialL = 3, maxL = 20)

## Example results with perplexity
plotGridSearchPerplexity(moduleSplit)

## Select model for downstream analysis
celdaMod <- subsetCeldaList(moduleSplit, list(L = 10))
data(celdaCGSim)
## Create models that range from L=3 to L=20 by recursively splitting modules
## into two
moduleSplit <- recursiveSplitModule(celdaCGSim$counts,
  initialL = 3, maxL = 20)

## Example results with perplexity
plotGridSearchPerplexity(moduleSplit)

## Select model for downstream analysis
celdaMod <- subsetCeldaList(moduleSplit, list(L = 10))
}
\seealso{
\code{recursiveSplitCell} for recursive splitting of cell
 populations.
}
