% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_heatmap.R
\name{celdaHeatmap}
\alias{celdaHeatmap}
\alias{celdaHeatmap,SingleCellExperiment-method}
\title{Plot celda Heatmap}
\usage{
celdaHeatmap(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  featureIx = NULL,
  nfeatures = 25,
  ...
)

\S4method{celdaHeatmap}{SingleCellExperiment}(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  featureIx = NULL,
  nfeatures = 25,
  ...
)
}
\arguments{
\item{sce}{A \link[SingleCellExperiment]{SingleCellExperiment} object
returned by \link{celda_C}, \link{celda_G}, or \link{celda_CG}.}

\item{useAssay}{A string specifying which \link{assay}
slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{featureIx}{Integer vector. Select features for display in heatmap. If
NULL, no subsetting will be performed. Default NULL. \strong{Only used for
\code{sce} containing celda_C model result returned by \link{celda_C}.}}

\item{nfeatures}{Integer. Maximum number of features to select for each
gene module. Default 25. \strong{Only used for \code{sce} containing
celda_CG or celda_G model results returned by \link{celda_CG} or
\link{celda_G}.}}

\item{...}{Additional parameters passed to \link{plotHeatmap}.}
}
\value{
list A list containing dendrogram information and the heatmap grob
}
\description{
Render a stylable heatmap of count data based on celda
 clustering results.
}
\examples{
data(sceCeldaCG)
celdaHeatmap(sceCeldaCG)
}
\seealso{
`celdaTsne()` for generating 2-dimensional tSNE coordinates
}
